"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockKibanaProvider = MockKibanaProvider;
exports.MockRouter = MockRouter;
exports.mockHistory = exports.mockDataView = exports.mockCore = exports.mockAppDataView = exports.getHistoryFromUrl = exports.forNearestButton = void 0;
exports.mockUseSeriesFilter = mockUseSeriesFilter;
exports.mockUxSeries = exports.mockUseValuesList = void 0;
exports.render = render;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _rxjs = require("rxjs");
var _react = _interopRequireDefault(require("react"));
var _queryString = require("query-string");
var _react2 = require("@testing-library/react");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _history = require("history");
var _i18nReact = require("@kbn/i18n-react");
var _mocks = require("@kbn/core/public/mocks");
var _public = require("@kbn/kibana-react-plugin/public");
var _eui = require("@elastic/eui");
var _mocks2 = require("@kbn/lens-plugin/public/mocks");
var _services = require("@kbn/unified-search-plugin/public/services");
var _stubs = require("@kbn/data-views-plugin/common/stubs");
var _mocks3 = require("@kbn/data-plugin/public/mocks");
var _mocks4 = require("@kbn/data-views-plugin/public/mocks");
var _mocks5 = require("@kbn/cases-plugin/public/mocks");
var _coreUiSettingsBrowserMocks = require("@kbn/core-ui-settings-browser-mocks");
var useValuesListHook = _interopRequireWildcard(require("@kbn/observability-shared-plugin/public/hooks/use_values_list"));
var _field_formats = require("./configurations/rum/field_formats");
var _use_app_data_view = _interopRequireWildcard(require("./hooks/use_app_data_view"));
var useAppDataViewHook = _use_app_data_view;
var _use_series_storage = require("./hooks/use_series_storage");
var useSeriesFilterHook = _interopRequireWildcard(require("./hooks/use_series_filters"));
var _test_data_view = _interopRequireDefault(require("./configurations/test_data/test_data_view.json"));
var _elasticsearch_fieldnames = require("./configurations/constants/elasticsearch_fieldnames");
var _obsv_exploratory_view = require("./obsv_exploratory_view");
var _exploratory_view_config = require("./contexts/exploratory_view_config");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/exploratory_view/public/components/shared/exploratory_view/rtl_helpers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// eslint-disable-next-line import/no-extraneous-dependencies
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getSetting(key) {
  if (key === 'timepicker:quickRanges') {
    return [{
      display: 'Today',
      from: 'now/d',
      to: 'now/d'
    }];
  }
  return 'MMM D, YYYY @ HH:mm:ss.SSS';
}
function setSetting$(key) {
  return (0, _rxjs.of)('MMM D, YYYY @ HH:mm:ss.SSS');
}

/* default mock core */
const defaultCore = _mocks.coreMock.createStart();
const mockCore = () => {
  const core = {
    ...defaultCore,
    security: undefined,
    application: {
      ...defaultCore.application,
      getUrlForApp: () => '/app/exploratory-view',
      navigateToUrl: jest.fn(),
      capabilities: {
        ...defaultCore.application.capabilities,
        observability: {
          'alerting:save': true,
          configureSettings: true,
          save: true,
          show: true
        }
      }
    },
    uiSettings: {
      ...defaultCore.uiSettings,
      get: getSetting,
      get$: setSetting$
    },
    settings: {
      ..._coreUiSettingsBrowserMocks.settingsServiceMock.createStartContract(),
      client: {
        ..._coreUiSettingsBrowserMocks.settingsServiceMock.createStartContract().client,
        get: getSetting,
        get$: setSetting$
      }
    },
    lens: _mocks2.lensPluginMock.createStartContract(),
    data: _mocks3.dataPluginMock.createStartContract(),
    dataViews: _mocks4.dataViewPluginMocks.createStartContract(),
    cases: _mocks5.casesPluginMock.createStartContract()
  };
  return core;
};

/* Mock Provider Components */
exports.mockCore = mockCore;
function MockKibanaProvider({
  children,
  core,
  kibanaProps
}) {
  const dataView = mockDataView;
  (0, _services.setIndexPatterns)({
    ...[dataView],
    get: async () => dataView
  });
  return /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, (0, _extends2.default)({
    services: {
      ...core
    }
  }, kibanaProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 159,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_use_app_data_view.DataViewContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 11
    }
  }, children))));
}
function MockRouter({
  children,
  core,
  history = (0, _history.createMemoryHistory)(),
  kibanaProps
}) {
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: '/app/exploratory-view/',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(MockKibanaProvider, {
    core: core,
    kibanaProps: kibanaProps,
    history: history,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 9
    }
  }, children)));
}

/* Custom react testing library render */
function render(ui, {
  history = (0, _history.createMemoryHistory)(),
  core: customCore,
  kibanaProps,
  renderOptions,
  url = '/app/exploratory-view/',
  initSeries = {}
} = {}) {
  if (url) {
    history = getHistoryFromUrl(url);
  }
  const core = {
    ...mockCore(),
    ...customCore
  };
  const seriesContextValue = mockSeriesStorageContext(initSeries);
  return {
    ...(0, _react2.render)(/*#__PURE__*/_react.default.createElement(MockRouter, {
      history: history,
      kibanaProps: kibanaProps,
      core: core,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_exploratory_view_config.ExploratoryViewContextProvider, (0, _extends2.default)({
      reportTypes: _obsv_exploratory_view.reportTypesList,
      dataTypes: _obsv_exploratory_view.dataTypes,
      reportConfigMap: _obsv_exploratory_view.obsvReportConfigMap,
      setHeaderActionMenu: jest.fn(),
      theme$: _mocks.themeServiceMock.createTheme$()
    }, defaultCore, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 212,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_use_series_storage.UrlStorageContext.Provider, {
      value: {
        ...seriesContextValue
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 11
      }
    }, ui))), renderOptions),
    history,
    core,
    ...seriesContextValue
  };
}
const getHistoryFromUrl = url => {
  if (typeof url === 'string') {
    return (0, _history.createMemoryHistory)({
      initialEntries: [url]
    });
  }
  return (0, _history.createMemoryHistory)({
    initialEntries: [url.path + (0, _queryString.stringify)(url.queryParams)]
  });
};
exports.getHistoryFromUrl = getHistoryFromUrl;
const mockAppDataView = props => {
  const loadDataView = jest.fn();
  const spy = jest.spyOn(useAppDataViewHook, 'useAppDataViewContext').mockReturnValue({
    dataView: mockDataView,
    hasData: true,
    loading: false,
    hasAppData: {
      ux: true
    },
    loadDataView,
    dataViews: {
      ux: mockDataView
    },
    dataViewErrors: {},
    ...(props || {})
  });
  return {
    spy,
    loadDataView
  };
};
exports.mockAppDataView = mockAppDataView;
const mockUseValuesList = values => {
  const onRefreshTimeRange = jest.fn();
  const spy = jest.spyOn(useValuesListHook, 'useValuesList').mockReturnValue({
    values: values !== null && values !== void 0 ? values : []
  });
  return {
    spy,
    onRefreshTimeRange
  };
};
exports.mockUseValuesList = mockUseValuesList;
const mockUxSeries = exports.mockUxSeries = {
  name: 'performance-distribution',
  dataType: 'ux',
  breakdown: 'user_agent.name',
  time: {
    from: 'now-15m',
    to: 'now'
  },
  reportDefinitions: {
    'service.name': ['elastic-co']
  },
  selectedMetricField: _elasticsearch_fieldnames.TRANSACTION_DURATION
};
function mockSeriesStorageContext({
  data,
  filters,
  breakdown
}) {
  const testSeries = {
    ...mockUxSeries,
    breakdown: breakdown || 'user_agent.name',
    ...(filters ? {
      filters
    } : {})
  };
  const mockDataSeries = data || [testSeries];
  const removeSeries = jest.fn();
  const setSeries = jest.fn();
  const getSeries = jest.fn().mockReturnValue(testSeries);
  return {
    removeSeries,
    setSeries,
    getSeries,
    autoApply: true,
    reportType: 'data-distribution',
    lastRefresh: Date.now(),
    setLastRefresh: jest.fn(),
    setAutoApply: jest.fn(),
    applyChanges: jest.fn(),
    firstSeries: mockDataSeries[0],
    allSeries: mockDataSeries,
    setReportType: jest.fn(),
    setChartTimeRangeContext: jest.fn(),
    storage: {
      get: jest.fn().mockImplementation(key => key === _use_series_storage.reportTypeKey ? 'data-distribution' : mockDataSeries)
    }
  };
}
function mockUseSeriesFilter() {
  const removeFilter = jest.fn();
  const invertFilter = jest.fn();
  const setFilter = jest.fn();
  const replaceFilter = jest.fn();
  const setFiltersWildcard = jest.fn();
  const spy = jest.spyOn(useSeriesFilterHook, 'useSeriesFilters').mockReturnValue({
    removeFilter,
    invertFilter,
    setFilter,
    replaceFilter,
    setFiltersWildcard
  });
  return {
    spy,
    removeFilter,
    invertFilter,
    setFilter,
    replaceFilter,
    setFiltersWildcard
  };
}
const hist = (0, _history.createMemoryHistory)();
const mockHistory = exports.mockHistory = {
  ...hist,
  createHref: jest.fn(({
    pathname
  }) => `/observability${pathname}`),
  push: jest.fn(),
  location: {
    ...hist.location,
    pathname: '/current-path'
  }
};
const fieldFormatMap = {};
_field_formats.rumFieldFormats.forEach(({
  field,
  format
}) => {
  fieldFormatMap[field] = format;
});
const mockDataView = exports.mockDataView = (0, _stubs.createStubDataView)({
  spec: {
    id: 'apm-*',
    title: 'apm-*',
    timeFieldName: '@timestamp',
    fields: JSON.parse(_test_data_view.default.attributes.fields),
    fieldFormats: fieldFormatMap
  }
});

// This function allows us to query for the nearest button with test
// no matter whether it has nested tags or not (as EuiButton elements do).
const forNearestButton = getByText => text => getByText((_content, node) => {
  if (!node) return false;
  const noOtherButtonHasText = Array.from(node.children).every(child => child && (child.textContent !== text || child.tagName.toLowerCase() !== 'button'));
  return noOtherButtonHasText && node.textContent === text && node.tagName.toLowerCase() === 'button';
});
exports.forNearestButton = forNearestButton;