"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventAnnotationGroupSavedObjectFinder = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/saved-objects-finder-plugin/public");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _eventAnnotationCommon = require("@kbn/event-annotation-common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/event_annotation/public/components/event_annotation_group_saved_object_finder.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const EventAnnotationGroupSavedObjectFinder = ({
  contentClient,
  uiSettings,
  fixedPageSize = 10,
  checkHasAnnotationGroups,
  onChoose,
  onCreateNew
}) => {
  const [hasAnnotationGroups, setHasAnnotationGroups] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    checkHasAnnotationGroups().then(setHasAnnotationGroups);
  }, [checkHasAnnotationGroups]);
  return hasAnnotationGroups === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }))) : hasAnnotationGroups === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    css: (0, _react2.css)`
        height: 100%;
      `,
    direction: "column",
    justifyContent: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    titleSize: "xs",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.emptyPromptTitle",
      defaultMessage: "Start by adding an annotation layer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 15
      }
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.emptyPromptDescription",
      defaultMessage: "There are currently no annotations available to select from the library. Create a new layer to add annotations.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 17
      }
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: () => onCreateNew(),
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.emptyCTA",
      defaultMessage: "Create annotation layer",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 15
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }))) : /*#__PURE__*/_react.default.createElement(_public.SavedObjectFinder, {
    id: "eventAnnotationGroup",
    key: "searchSavedObjectFinder",
    fixedPageSize: fixedPageSize,
    onChoose: (id, type, fullName, savedObject) => {
      onChoose({
        id,
        type,
        fullName,
        savedObject
      });
    },
    showFilter: false,
    noItemsMessage: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotation.eventAnnotationGroup.savedObjectFinder.notFoundLabel",
      defaultMessage: "No matching annotation groups found.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 9
      }
    }),
    savedObjectMetaData: savedObjectMetaData,
    services: {
      contentClient,
      uiSettings
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  });
};
exports.EventAnnotationGroupSavedObjectFinder = EventAnnotationGroupSavedObjectFinder;
const savedObjectMetaData = [{
  type: _eventAnnotationCommon.EVENT_ANNOTATION_GROUP_TYPE,
  getIconForSavedObject: () => 'annotation',
  name: _i18n.i18n.translate('eventAnnotation.eventAnnotationGroup.metadata.name', {
    defaultMessage: 'Annotations Groups'
  }),
  includeFields: ['*']
}];