"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.autocomplete = autocomplete;
var _i18n = require("@kbn/i18n");
var _helpers = require("../../../definitions/utils/autocomplete/helpers");
var _complete_items = require("../../complete_items");
var _literals = require("../../../definitions/utils/literals");
var _types = require("../../../definitions/types");
var _functions = require("../../../definitions/utils/autocomplete/functions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function autocomplete(query, command, callbacks, context, cursorPosition) {
  var _callbacks$getByType;
  const innerText = query.substring(0, cursorPosition);
  const commandArgs = command.args.filter(arg => !Array.isArray(arg) && arg.type !== 'unknown');
  const functionsSpecificSuggestions = await (0, _functions.getInsideFunctionsSuggestions)(innerText, cursorPosition, callbacks, context);
  if (functionsSpecificSuggestions) {
    return functionsSpecificSuggestions;
  }

  // GROK field /
  if (commandArgs.length === 1 && /\s$/.test(innerText)) {
    return (0, _literals.buildConstantsDefinitions)(['"%{WORD:firstWord}"'], _i18n.i18n.translate('kbn-esql-ast.esql.autocomplete.aPatternString', {
      defaultMessage: 'A pattern string'
    }), undefined, {
      advanceCursorAndOpenSuggestions: true
    });
  }
  // GROK field pattern /
  else if (commandArgs.length === 2) {
    return [(0, _helpers.withAutoSuggest)(_complete_items.pipeCompleteItem)];
  }

  // GROK /
  const fieldSuggestions = (await (callbacks === null || callbacks === void 0 ? void 0 : (_callbacks$getByType = callbacks.getByType) === null || _callbacks$getByType === void 0 ? void 0 : _callbacks$getByType.call(callbacks, _types.ESQL_STRING_TYPES))) || [];
  return fieldSuggestions.map(sug => {
    return (0, _helpers.withAutoSuggest)({
      ...sug,
      text: `${sug.text} `
    });
  });
}