"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionChartWithLens = exports.AnalyticsCollectionChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _moment = _interopRequireDefault(require("moment"));
var _charts = require("@elastic/charts");
var _formatters = require("@elastic/charts/dist/utils/data/formatters");
var _eui = require("@elastic/eui");
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _kibana = require("../../../../shared/kibana");
var _with_lens_data = require("../../../hoc/with_lens_data");
var _get_formula_by_filter = require("../../../utils/get_formula_by_filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/analytics/components/analytics_collection_view/analytics_collection_overview/analytics_collection_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DEFAULT_STROKE_WIDTH = 1;
const HOVER_STROKE_WIDTH = 3;
const CHART_HEIGHT = 490;
const AnalyticsCollectionChart = ({
  data,
  timeRange,
  isLoading,
  selectedChart,
  setSelectedChart
}) => {
  const [currentData, setCurrentData] = (0, _react.useState)(data);
  const [hoverChart, setHoverChart] = (0, _react.useState)(null);
  const {
    uiSettings,
    charts: chartSettings
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const fromDateParsed = _datemath.default.parse(timeRange.from);
  const toDataParsed = _datemath.default.parse(timeRange.to);
  const baseChartTheme = chartSettings === null || chartSettings === void 0 ? void 0 : chartSettings.theme.useChartsBaseTheme();
  const charts = (0, _react.useMemo)(() => [{
    chartColor: _uiTheme.euiThemeVars.euiColorVis0,
    data: currentData[_get_formula_by_filter.FilterBy.Searches] || [],
    id: _get_formula_by_filter.FilterBy.Searches,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.searches', {
      defaultMessage: 'Searches'
    })
  }, {
    chartColor: _uiTheme.euiThemeVars.euiColorVis2,
    data: currentData[_get_formula_by_filter.FilterBy.NoResults] || [],
    id: _get_formula_by_filter.FilterBy.NoResults,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.noResults', {
      defaultMessage: 'No results'
    })
  }, {
    chartColor: _uiTheme.euiThemeVars.euiColorVis3,
    data: currentData[_get_formula_by_filter.FilterBy.Clicks] || [],
    id: _get_formula_by_filter.FilterBy.Clicks,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.clicks', {
      defaultMessage: 'Click'
    })
  }, {
    chartColor: _uiTheme.euiThemeVars.euiColorVis5,
    data: currentData[_get_formula_by_filter.FilterBy.Sessions] || [],
    id: _get_formula_by_filter.FilterBy.Sessions,
    name: _i18n.i18n.translate('xpack.enterpriseSearch.analytics.collections.collectionsView.charts.sessions', {
      defaultMessage: 'Sessions'
    })
  }], [currentData]);
  (0, _react.useEffect)(() => {
    if (Object.keys(data).length !== 0) {
      setCurrentData(data);
    }
  }, [data]);
  return isLoading && Object.keys(currentData).length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    css: {
      height: CHART_HEIGHT
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  })) : /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: ['100%', CHART_HEIGHT],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseChartTheme,
    showLegend: false,
    onElementClick: elements => {
      var _$;
      const chartId = (_$ = elements[0][1]) === null || _$ === void 0 ? void 0 : _$.specId;
      if (chartId) {
        setSelectedChart(chartId);
      }
    },
    onElementOver: elements => {
      var _$2;
      const chartId = (_$2 = elements[0][1]) === null || _$2 === void 0 ? void 0 : _$2.specId;
      if (chartId) {
        setHoverChart(chartId);
      }
    },
    onElementOut: () => setHoverChart(null),
    locale: _i18n.i18n.getLocale(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }), charts.map(({
    data: chartData,
    id,
    name,
    chartColor
  }) => /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: id,
    key: id,
    name: name,
    data: chartData,
    color: chartColor,
    xAccessor: 0,
    yAccessors: [1],
    areaSeriesStyle: {
      area: {
        opacity: 0.2,
        visible: selectedChart === id
      },
      line: {
        opacity: selectedChart === id ? 1 : 0.5,
        strokeWidth: [hoverChart, selectedChart].includes(id) ? HOVER_STROKE_WIDTH : DEFAULT_STROKE_WIDTH
      }
    },
    yNice: true
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Sqrt,
    curve: _charts.CurveType.CURVE_MONOTONE_X,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom-axis",
    position: _charts.Position.Bottom,
    tickFormat: fromDateParsed && toDataParsed ? (0, _formatters.niceTimeFormatter)([fromDateParsed.valueOf(), toDataParsed.valueOf()]) : undefined,
    gridLine: {
      visible: true
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    gridLine: {
      dash: [],
      visible: true
    },
    hide: true,
    id: "left-axis",
    position: _charts.Position.Left,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: tooltipData => (0, _moment.default)(tooltipData.value).format(uiSettings === null || uiSettings === void 0 ? void 0 : uiSettings.get('dateFormat')),
    maxTooltipItems: 1,
    type: _charts.TooltipType.VerticalCursor,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 7
    }
  }));
};
exports.AnalyticsCollectionChart = AnalyticsCollectionChart;
const initialValues = {
  data: {},
  isLoading: true
};
const LENS_LAYERS = Object.values(_get_formula_by_filter.FilterBy).map(id => ({
  formula: (0, _get_formula_by_filter.getFormulaByFilter)(id),
  id,
  x: 'timeline',
  y: 'values'
}));
const AnalyticsCollectionChartWithLens = exports.AnalyticsCollectionChartWithLens = (0, _with_lens_data.withLensData)(AnalyticsCollectionChart, {
  dataLoadTransform: (isLoading, adapters) => isLoading || !adapters ? initialValues : {
    data: LENS_LAYERS.reduce((results, {
      id,
      x,
      y
    }) => {
      var _adapters$tables, _adapters$tables$tabl, _adapters$tables$tabl2;
      return {
        ...results,
        [id]: ((_adapters$tables = adapters.tables) === null || _adapters$tables === void 0 ? void 0 : (_adapters$tables$tabl = _adapters$tables.tables[id]) === null || _adapters$tables$tabl === void 0 ? void 0 : (_adapters$tables$tabl2 = _adapters$tables$tabl.rows) === null || _adapters$tables$tabl2 === void 0 ? void 0 : _adapters$tables$tabl2.map(row => [row[x], row[y]])) || []
      };
    }, {}),
    isLoading: false
  },
  getAttributes: dataView => {
    return {
      references: [{
        id: dataView.id,
        name: 'indexpattern-datasource-current-indexpattern',
        type: 'index-pattern'
      }, ...LENS_LAYERS.map(({
        id
      }) => ({
        id: dataView.id,
        name: `indexpattern-datasource-layer-${id}`,
        type: 'index-pattern'
      }))],
      state: {
        datasourceStates: {
          formBased: {
            layers: LENS_LAYERS.reduce((results, {
              id,
              x,
              y,
              formula
            }) => ({
              ...results,
              [id]: {
                [x]: {
                  dataType: 'date',
                  isBucketed: false,
                  label: 'Timestamp',
                  operationType: 'date_histogram',
                  params: {
                    includeEmptyRows: true,
                    interval: 'auto'
                  },
                  scale: 'ordinal',
                  sourceField: dataView === null || dataView === void 0 ? void 0 : dataView.timeFieldName
                },
                [y]: {
                  dataType: 'number',
                  isBucketed: false,
                  label: formula,
                  operationType: 'formula',
                  params: {
                    formula,
                    isFormulaBroken: false
                  },
                  references: []
                }
              }
            }), {})
          }
        },
        filters: [],
        query: {
          language: 'kuery',
          query: ''
        },
        visualization: {
          axisTitlesVisibilitySettings: {
            x: false,
            yLeft: false,
            yRight: false
          },
          curveType: 'CURVE_MONOTONE_X',
          fittingFunction: 'None',
          gridlinesVisibilitySettings: {
            x: true,
            yLeft: true,
            yRight: true
          },
          layers: LENS_LAYERS.map(({
            id,
            x,
            y
          }) => ({
            accessors: [y],
            layerId: [id],
            layerType: 'data',
            seriesType: 'area',
            xAccessor: x,
            yConfig: [{
              forAccessor: y
            }]
          })),
          legend: {
            isVisible: false
          },
          preferredSeriesType: 'area',
          valueLabels: 'hide'
        }
      },
      title: '',
      visualizationType: 'lnsXY'
    };
  },
  initialValues
});