"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateAnonymizationFieldsRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateAnonymizationFieldsRoute = router => {
  router.versioned.post({
    access: 'internal',
    path: _elasticAssistantCommon.UPDATE_ANONYMIZATION_FIELDS_URL,
    security: {
      authz: {
        requiredPrivileges: ['elasticAssistant']
      }
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.internal.v1,
    validate: {}
  }, async (context, request, response) => {
    const assistantContext = await context.elasticAssistant;
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    try {
      await assistantContext.updateAnonymizationFields();
      return response.ok({
        body: {
          success: true
        }
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: {
          message: error.message,
          full_error: JSON.stringify(e)
        },
        bypassErrorFormat: true
      });
    }
  });
};
exports.updateAnonymizationFieldsRoute = updateAnonymizationFieldsRoute;