"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryService = void 0;
var _telemetry_events = require("./events/telemetry_events");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Service that interacts with the Core's analytics module
 * to trigger custom event for Security Solution plugin features
 */
class TelemetryService {
  constructor(analytics = null) {
    this.analytics = analytics;
  }
  setup({
    analytics
  }) {
    this.analytics = analytics;
    _telemetry_events.telemetryEvents.forEach(eventConfig => analytics.registerEventType(eventConfig));
  }
  start() {
    var _this$analytics;
    const reportEvent = (_this$analytics = this.analytics) === null || _this$analytics === void 0 ? void 0 : _this$analytics.reportEvent.bind(this.analytics);
    if (!this.analytics || !reportEvent) {
      throw new Error('The TelemetryService.setup() method has not been invoked, be sure to call it during the plugin setup.');
    }
    return {
      reportEvent
    };
  }
}
exports.TelemetryService = TelemetryService;