"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardUpdateResultSchema = exports.dashboardUpdateRequestAttributesSchema = exports.dashboardUpdateOptionsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _contentManagementUtils = require("@kbn/content-management-utils");
var _common = require("./common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const dashboardUpdateOptionsSchema = exports.dashboardUpdateOptionsSchema = _configSchema.schema.object({
  references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_common.referenceSchema)),
  mergeAttributes: _configSchema.schema.maybe(_contentManagementUtils.updateOptionsSchema.mergeAttributes)
});
const dashboardUpdateRequestAttributesSchema = exports.dashboardUpdateRequestAttributesSchema = _configSchema.schema.object({
  ..._common.dashboardState,
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  references: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_common.referenceSchema)),
  spaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string()))
});
const dashboardUpdateResultSchema = exports.dashboardUpdateResultSchema = _common.dashboardAPICreateResultSchema;