"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DashboardListingTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _contentManagementTableListViewTable = require("@kbn/content-management-table-list-view-table");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _kibana_services = require("../services/kibana_services");
var _dashboard_unsaved_listing = require("./dashboard_unsaved_listing");
var _use_dashboard_listing_table = require("./hooks/use_dashboard_listing_table");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_listing/dashboard_listing_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const DashboardListingTable = ({
  disableCreateDashboardButton,
  initialFilter,
  goToDashboard,
  getDashboardUrl,
  useSessionStorageIntegration,
  urlStateEnabled,
  showCreateDashboardButton = true
}) => {
  (0, _public.useExecutionContext)(_kibana_services.coreServices.executionContext, {
    type: 'application',
    page: 'list'
  });
  const {
    unsavedDashboardIds,
    refreshUnsavedDashboards,
    tableListViewTableProps: {
      title: tableCaption,
      ...tableListViewTable
    },
    contentInsightsClient
  } = (0, _use_dashboard_listing_table.useDashboardListingTable)({
    disableCreateDashboardButton,
    goToDashboard,
    getDashboardUrl,
    urlStateEnabled,
    useSessionStorageIntegration,
    initialFilter,
    showCreateDashboardButton
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewKibanaProvider, {
    core: _kibana_services.coreServices,
    savedObjectsTagging: _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi(),
    FormattedRelative: _i18nReact.FormattedRelative,
    contentInsightsClient: contentInsightsClient,
    isKibanaVersioningEnabled: !_kibana_services.serverlessService,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_dashboard_unsaved_listing.DashboardUnsavedListing, {
    goToDashboard: goToDashboard,
    unsavedDashboardIds: unsavedDashboardIds,
    refreshUnsavedDashboards: refreshUnsavedDashboards,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_contentManagementTableListViewTable.TableListViewTable, (0, _extends2.default)({
    tableCaption: tableCaption
  }, tableListViewTable, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  })))));
};
exports.DashboardListingTable = DashboardListingTable;