"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SHORT_CONTAINER_QUERY = exports.MarkdownFooter = exports.FOOTER_HELP_TEXT = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _use_memo_css = require("@kbn/css-utils/public/use_memo_css");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard_markdown/public/components/markdown_footer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const FOOTER_HELP_TEXT = exports.FOOTER_HELP_TEXT = (0, _eui.htmlIdGenerator)()('markdownEditorFooterHelp');

// Container query for when the height is too short and we need to switch to a more compact layout
const SHORT_CONTAINER_QUERY = exports.SHORT_CONTAINER_QUERY = `@container (max-height: 119px)`;
const footerStyles = {
  footer: ({
    euiTheme
  }) => (0, _react2.css)({
    borderRadius: `0 0 ${euiTheme.size.s} ${euiTheme.size.s}`,
    width: '100%',
    borderTop: `1px solid ${euiTheme.colors.borderBasePlain}`,
    position: 'absolute',
    bottom: 0,
    '&::before': {
      content: "''",
      position: 'absolute',
      background: euiTheme.colors.backgroundBasePlain,
      opacity: 0.9,
      inset: 0
    },
    [SHORT_CONTAINER_QUERY]: {
      borderTop: 'none',
      right: 0,
      width: 'auto',
      zIndex: 1,
      '&::before': {
        background: 'none'
      }
    }
  }),
  buttonsContainer: ({
    euiTheme
  }) => (0, _react2.css)({
    margin: euiTheme.size.s,
    position: 'relative'
  }),
  previewFooter: ({
    euiTheme
  }) => (0, _react2.css)({
    opacity: 0,
    transition: `${_eui.euiCanAnimate ? `opacity ${euiTheme.animation.slow} ease-in` : undefined}`,
    '.dshDashboardGrid__item:hover &': {
      opacity: 1
    }
  })
};
const strings = {
  discardButton: _i18n.i18n.translate('dashboardMarkdown.discardButton', {
    defaultMessage: 'Discard'
  }),
  applyButton: _i18n.i18n.translate('dashboardMarkdown.applyButton', {
    defaultMessage: 'Apply'
  }),
  applyButtonDisabledTooltip: _i18n.i18n.translate('dashboardMarkdown.applyButtonDisabledTooltip', {
    defaultMessage: 'No changes to save'
  }),
  markdownFooterHelpText: _i18n.i18n.translate('dashboardMarkdown.footerHelpText', {
    defaultMessage: 'Press Apply to save your changes or Discard to cancel.'
  })
};
const MarkdownFooter = ({
  onCancel,
  onSave,
  isPreview,
  cancelButtonRef,
  isSaveable
}) => {
  const styles = (0, _use_memo_css.useMemoCss)(footerStyles);
  return /*#__PURE__*/_react.default.createElement("div", {
    css: [styles.footer, isPreview && styles.previewFooter],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    id: FOOTER_HELP_TEXT,
    hidden: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, strings.markdownFooterHelpText), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexEnd",
    css: styles.buttonsContainer,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "markdownEditorDiscardButton",
    color: "primary",
    size: "xs",
    onClick: onCancel,
    buttonRef: cancelButtonRef,
    onKeyDown: e => {
      if (e.key === 'Escape') {
        onCancel();
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 11
    }
  }, strings.discardButton)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 9
    }
  }, isSaveable ? /*#__PURE__*/_react.default.createElement(SaveButton, {
    onSave: onSave,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: strings.applyButtonDisabledTooltip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(SaveButton, {
    onSave: onSave,
    disabled: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 15
    }
  })))));
};
exports.MarkdownFooter = MarkdownFooter;
const SaveButton = ({
  onSave,
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "markdownEditorApplyButton",
    size: 'xs',
    color: "primary",
    fill: true,
    onClick: onSave,
    css: (0, _react2.css)({
      minInlineSize: 'initial'
    }),
    disabled: disabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 5
    }
  }, strings.applyButton);
};