"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexEdit = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _breadcrumbs = require("../../services/breadcrumbs");
var _public = require("@kbn/kibana-react-plugin/public");
var _components = require("../../components");
var _constants = require("../../constants");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/sections/follower_index_edit/follower_index_edit.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FollowerIndexEdit extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      lastFollowerIndexId: undefined,
      showConfirmModal: false
    });
    (0, _defineProperty2.default)(this, "saveFollowerIndex", (name, followerIndex) => {
      this.editedFollowerIndexPayload = {
        name,
        followerIndex
      };
      this.showConfirmModal();
    });
    (0, _defineProperty2.default)(this, "confirmSaveFollowerIhdex", () => {
      const {
        name,
        followerIndex
      } = this.editedFollowerIndexPayload;
      this.props.saveFollowerIndex(name, followerIndex);
      this.closeConfirmModal();
    });
    (0, _defineProperty2.default)(this, "showConfirmModal", () => this.setState({
      showConfirmModal: true
    }));
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => this.setState({
      showConfirmModal: false
    }));
    (0, _defineProperty2.default)(this, "renderConfirmModal", () => {
      const {
        followerIndexId,
        followerIndex: {
          isPaused
        }
      } = this.props;
      const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
      const title = _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexEditForm.confirmModal.title', {
        defaultMessage: `Update follower index ''{id}''?`,
        values: {
          id: followerIndexId
        }
      });
      return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
        "aria-labelledby": confirmModalTitleId,
        title: title,
        titleProps: {
          id: confirmModalTitleId
        },
        onCancel: this.closeConfirmModal,
        onConfirm: this.confirmSaveFollowerIhdex,
        cancelButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexEditForm.confirmModal.cancelButtonText', {
          defaultMessage: 'Cancel'
        }),
        confirmButtonText: isPaused ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexEditForm.confirmModal.confirmAndResumeButtonText",
          defaultMessage: "Update and resume",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 13
          }
        }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexEditForm.confirmModal.confirmButtonText",
          defaultMessage: "Update",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 193,
            columnNumber: 13
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 200,
          columnNumber: 9
        }
      }, isPaused ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexEditForm.confirmModal.resumeDescription",
        defaultMessage: "Updating a follower index resumes replication of its leader index.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 202,
          columnNumber: 13
        }
      }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexEditForm.confirmModal.description",
        defaultMessage: "The follower index is paused, then resumed. If the update fails, try manually resuming replication.",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 207,
          columnNumber: 13
        }
      })));
    });
  }
  static getDerivedStateFromProps({
    followerIndexId
  }, {
    lastFollowerIndexId
  }) {
    if (lastFollowerIndexId !== followerIndexId) {
      return {
        lastFollowerIndexId: followerIndexId
      };
    }
    return null;
  }
  componentDidMount() {
    const {
      match: {
        params: {
          id
        }
      },
      selectFollowerIndex
    } = this.props;
    let decodedId;
    try {
      // When we navigate through the router (history.push) we need to decode both the uri and the id
      decodedId = decodeURI(id);
      decodedId = decodeURIComponent(decodedId);
    } catch (e) {
      // This is a page load. I guess that AngularJS router does already a decodeURI so it is not
      // necessary in this case.
      decodedId = decodeURIComponent(id);
    }
    selectFollowerIndex(decodedId);
    (0, _breadcrumbs.setBreadcrumbs)([(0, _breadcrumbs.listBreadcrumb)('/follower_indices'), _breadcrumbs.editBreadcrumb]);
  }
  componentDidUpdate(prevProps, prevState) {
    const {
      followerIndex,
      getFollowerIndex
    } = this.props;
    // Fetch the follower index on the server if we don't have it (i.e. page reload)
    if (!followerIndex && prevState.lastFollowerIndexId !== this.state.lastFollowerIndexId) {
      getFollowerIndex(this.state.lastFollowerIndexId);
    }
  }
  componentWillUnmount() {
    this.props.clearApiError();
  }
  renderLoading(loadingTitle) {
    return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 12
      }
    }, loadingTitle);
  }
  renderGetFollowerIndexError(error) {
    const {
      match: {
        params: {
          id: name
        }
      }
    } = this.props;
    const errorMessage = error.body.statusCode === 404 ? {
      error: _i18n.i18n.translate('xpack.crossClusterReplication.followerIndexEditForm.loadingErrorMessage', {
        defaultMessage: `The follower index ''{name}'' does not exist.`,
        values: {
          name
        }
      })
    } : error;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
      color: "danger",
      iconType: "warning",
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexEditForm.loadingErrorTitle",
        defaultMessage: "Error loading follower index",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 135,
          columnNumber: 13
        }
      })),
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 15
        }
      }, errorMessage),
      actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(this.props.history, `/follower_indices`), {
        color: "danger",
        flush: "left",
        iconType: "arrowLeft",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.crossClusterReplication.followerIndexEditForm.viewFollowerIndicesButtonLabel",
        defaultMessage: "View follower indices",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 13
        }
      })),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 7
      }
    });
  }
  render() {
    const {
      clearApiError,
      apiStatus,
      apiError,
      followerIndex,
      match: {
        url: currentUrl
      }
    } = this.props;
    const {
      showConfirmModal
    } = this.state;

    /* remove non-editable properties */
    const {
      shards,
      ...rest
    } = followerIndex || {}; // eslint-disable-line no-unused-vars

    if (apiStatus.get === _constants.API_STATUS.LOADING || !followerIndex) {
      return this.renderLoading(_i18n.i18n.translate('xpack.crossClusterReplication.followerIndexEditForm.loadingFollowerIndexTitle', {
        defaultMessage: 'Loading follower index…'
      }));
    }
    if (apiError.get) {
      return this.renderGetFollowerIndexError(apiError.get);
    }
    return /*#__PURE__*/_react.default.createElement(_components.RemoteClustersProvider, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 246,
        columnNumber: 7
      }
    }, ({
      isLoading,
      error,
      remoteClusters
    }) => {
      if (isLoading) {
        return this.renderLoading(_i18n.i18n.translate('xpack.crossClusterReplication.followerIndexEditForm.loadingRemoteClustersMessage', {
          defaultMessage: 'Loading remote clusters…'
        }));
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiPageSection, {
        restrictWidth: true,
        style: {
          width: '100%'
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 258,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_components.FollowerIndexPageTitle, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndex.editTitle",
          defaultMessage: "Edit follower index",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 261,
            columnNumber: 19
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 15
        }
      }), /*#__PURE__*/_react.default.createElement(_components.FollowerIndexForm, {
        followerIndex: rest,
        apiStatus: apiStatus.save,
        apiError: apiError.save,
        currentUrl: currentUrl,
        remoteClusters: error ? [] : remoteClusters,
        saveFollowerIndex: this.saveFollowerIndex,
        clearApiError: clearApiError,
        saveButtonLabel: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.followerIndexEditForm.saveButtonLabel",
          defaultMessage: "Update",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 277,
            columnNumber: 19
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 268,
          columnNumber: 15
        }
      }), showConfirmModal && this.renderConfirmModal());
    });
  }
}
exports.FollowerIndexEdit = FollowerIndexEdit;
(0, _defineProperty2.default)(FollowerIndexEdit, "propTypes", {
  getFollowerIndex: _propTypes.default.func.isRequired,
  selectFollowerIndex: _propTypes.default.func.isRequired,
  saveFollowerIndex: _propTypes.default.func.isRequired,
  clearApiError: _propTypes.default.func.isRequired,
  apiError: _propTypes.default.object.isRequired,
  apiStatus: _propTypes.default.object.isRequired,
  followerIndex: _propTypes.default.object,
  followerIndexId: _propTypes.default.string
});