"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Template = void 0;
var _react = _interopRequireWildcard(require("react"));
var _coreBaseCommon = require("@kbn/core-base-common");
var _i18n = require("@kbn/i18n");
var _fonts = require("./fonts");
var _logo = require("./logo");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/rendering/server-internal/src/views/template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const Template = ({
  metadata: {
    uiPublicUrl,
    locale,
    darkMode,
    stylesheetPaths,
    scriptPaths,
    injectedMetadata,
    bootstrapScriptUrl,
    hardenPrototypes,
    strictCsp,
    customBranding
  }
}) => {
  var _customBranding$pageT, _customBranding$favic, _customBranding$favic2;
  const title = (_customBranding$pageT = customBranding.pageTitle) !== null && _customBranding$pageT !== void 0 ? _customBranding$pageT : 'Elastic';
  const favIcon = (_customBranding$favic = customBranding.faviconSVG) !== null && _customBranding$favic !== void 0 ? _customBranding$favic : `${uiPublicUrl}/favicons/favicon.svg`;
  const favIconPng = (_customBranding$favic2 = customBranding.faviconPNG) !== null && _customBranding$favic2 !== void 0 ? _customBranding$favic2 : `${uiPublicUrl}/favicons/favicon.png`;
  const logo = customBranding.logo ? /*#__PURE__*/_react.default.createElement("img", {
    src: customBranding.logo,
    width: "64",
    height: "64",
    alt: "logo",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_logo.Logo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement("html", {
    lang: locale,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("head", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("meta", {
    charSet: "utf-8",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    httpEquiv: "X-UA-Compatible",
    content: "IE=edge,chrome=1",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: "viewport",
    content: "width=device-width",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("title", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 9
    }
  }, title), /*#__PURE__*/_react.default.createElement(_fonts.Fonts, {
    url: uiPublicUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("link", {
    rel: "alternate icon",
    type: "image/png",
    href: favIconPng,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("link", {
    rel: "icon",
    type: "image/svg+xml",
    href: favIcon,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: "theme-color",
    content: "#ffffff",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: "color-scheme",
    content: "light dark",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: _coreBaseCommon.EUI_STYLES_GLOBAL,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: "emotion",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_styles.Styles, {
    darkMode: darkMode,
    themeName: injectedMetadata.theme.name,
    stylesheetPaths: stylesheetPaths,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 9
    }
  }), scriptPaths.map(path => /*#__PURE__*/_react.default.createElement("script", {
    key: path,
    src: path,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("meta", {
    name: "add-styles-here",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: "add-scripts-here",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement("meta", {
    name: _coreBaseCommon.EUI_STYLES_UTILS,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("body", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/(0, _react.createElement)('kbn-csp', {
    data: JSON.stringify({
      strictCsp
    })
  }), /*#__PURE__*/(0, _react.createElement)('kbn-prototype-hardening', {
    data: JSON.stringify({
      hardenPrototypes
    })
  }), /*#__PURE__*/(0, _react.createElement)('kbn-injected-metadata', {
    data: JSON.stringify(injectedMetadata)
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnWelcomeView",
    id: "kbn_loading_message",
    style: {
      display: 'none'
    },
    "data-test-subj": "kbnLoadingMessage",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnLoaderWrap",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 11
    }
  }, logo, /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnWelcomeText",
    "data-error-message-title": _i18n.i18n.translate('core.ui.welcomeErrorMessageTitle', {
      defaultMessage: 'Elastic did not load properly'
    }),
    "data-error-message-text": _i18n.i18n.translate('core.ui.welcomeErrorMessageText', {
      defaultMessage: 'Please reload this page. If the issue persists, check the browser console and server logs.'
    }),
    "data-error-message-reload": _i18n.i18n.translate('core.ui.welcomeErrorReloadButton', {
      defaultMessage: 'Reload'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('core.ui.welcomeMessage', {
    defaultMessage: 'Loading Elastic'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnProgress",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnWelcomeView",
    id: "kbn_legacy_browser_error",
    style: {
      display: 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  }, logo, /*#__PURE__*/_react.default.createElement("h2", {
    className: "kbnWelcomeTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('core.ui.legacyBrowserTitle', {
    defaultMessage: 'Please upgrade your browser'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "kbnWelcomeText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('core.ui.legacyBrowserMessage', {
    defaultMessage: 'This Elastic installation has strict security requirements enabled that your current browser does not meet.'
  }))), /*#__PURE__*/_react.default.createElement("script", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 9
    }
  }, `// kbnUnsafeInlineTest do not remove this comment:
            //   it is used for filtering out expected CSP failures, and must be the first piece of content in this script block.
            // Since this is an unsafe inline script, this code will not run
            // in browsers that support content security policy(CSP). This is
            // intentional as we check for the existence of __kbnCspNotEnforced__ in
            // bootstrap.
            window.__kbnCspNotEnforced__ = true;
          `), /*#__PURE__*/_react.default.createElement("script", {
    src: bootstrapScriptUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  })));
};
exports.Template = Template;