"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FavoritesRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class FavoritesRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "favoriteTypes", new Map());
  }
  registerFavoriteType(type, config = {}) {
    if (this.favoriteTypes.has(type)) {
      throw new Error(`Favorite type ${type} is already registered`);
    }
    this.favoriteTypes.set(type, config);
  }
  hasType(type) {
    return this.favoriteTypes.has(type);
  }
  validateMetadata(type, metadata) {
    if (!this.hasType(type)) {
      throw new Error(`Favorite type ${type} is not registered`);
    }
    const typeConfig = this.favoriteTypes.get(type);
    const typeMetadataSchema = typeConfig.typeMetadataSchema;
    if (typeMetadataSchema) {
      typeMetadataSchema.validate(metadata);
    } else {
      if (metadata === undefined) {
        return; /* ok */
      } else {
        throw new Error(`Favorite type ${type} does not support metadata`);
      }
    }
  }
}
exports.FavoritesRegistry = FavoritesRegistry;