"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnassignedTermsConfig = UnassignedTermsConfig;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
var _react2 = require("@emotion/react");
var _palettes = require("@kbn/palettes");
var _color_mapping = require("../../state/color_mapping");
var _default_color_mapping = require("../../config/default_color_mapping");
var _special_assignment = require("../assignment/special_assignment");
var _selectors = require("../../state/selectors");
var _utils = require("../../config/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/components/container/unassigned_terms_config.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function UnassignedTermsConfig({
  palettes,
  data,
  isDarkMode
}) {
  const dispatch = (0, _reactRedux.useDispatch)();
  const neutralPalette = palettes.get(_palettes.KbnPalette.Neutral);
  const palette = (0, _reactRedux.useSelector)((0, _selectors.selectPalette)(palettes));
  const colorMode = (0, _reactRedux.useSelector)(_selectors.selectColorMode);
  const specialAssignments = (0, _reactRedux.useSelector)(_selectors.selectSpecialAssignments);
  const assignments = (0, _reactRedux.useSelector)(_selectors.selectComputedAssignments);
  const otherAssignmentColor = (0, _utils.getOtherAssignmentColor)(specialAssignments, assignments);
  const colorModes = [{
    id: 'loop',
    label: colorMode.type === 'gradient' ? _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsMode.ReuseGradientLabel', {
      defaultMessage: 'Gradient'
    }) : _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsMode.ReuseColorsLabel', {
      defaultMessage: 'Color palette'
    })
  }, {
    id: 'static',
    label: _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsMode.SingleColorLabel', {
      defaultMessage: 'Single color'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('coloring.colorMapping.container.unassignedTermsModeHeader', {
      defaultMessage: 'Color for unassigned terms'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: 'Color mode',
    options: colorModes,
    idSelected: otherAssignmentColor.isLoop ? 'loop' : 'static',
    onChange: optionId => {
      dispatch((0, _color_mapping.updateSpecialAssignmentColor)({
        assignmentIndex: 0,
        color: optionId === 'loop' ? {
          type: 'loop'
        } : {
          type: 'categorical',
          colorIndex: _default_color_mapping.DEFAULT_NEUTRAL_PALETTE_INDEX,
          paletteId: neutralPalette.id
        }
      }));
    },
    buttonSize: "compressed",
    isFullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
              visibility: ${otherAssignmentColor.isLoop ? 'hidden' : 'visible'};
              width: 32px;
              height: 32px;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, data.type === 'categories' && otherAssignmentColor.isLoop === false && /*#__PURE__*/_react.default.createElement(_special_assignment.SpecialAssignment, {
    index: 0,
    palette: palette,
    isDarkMode: isDarkMode,
    palettes: palettes,
    assignmentColor: otherAssignmentColor.color,
    total: specialAssignments.length,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 15
    }
  })))));
}