"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CategoricalColorMapping = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _toolkit = require("@reduxjs/toolkit");
var _lodash = require("lodash");
var _color_mapping = require("./state/color_mapping");
var _container = require("./components/container/container");
var _ui = require("./state/ui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/color_mapping/categorical_color_mapping.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * A configuration object that is required to populate correctly the visible categories
 * or the ranges in the CategoricalColorMapping component
 */

/**
 * The props of the CategoricalColorMapping component
 */

/**
 * The React component for mapping categorical values to colors
 */
class CategoricalColorMapping extends _react.default.Component {
  constructor(props) {
    super(props);
    // configure the store at mount time
    (0, _defineProperty2.default)(this, "store", void 0);
    (0, _defineProperty2.default)(this, "unsubscribe", void 0);
    this.store = (0, _toolkit.configureStore)({
      preloadedState: {
        colorMapping: props.model
      },
      reducer: {
        colorMapping: _color_mapping.colorMappingReducer,
        ui: _ui.uiReducer
      }
    });
    // subscribe to store changes to update external tools
    this.unsubscribe = this.store.subscribe(() => {
      this.props.onModelUpdate(this.store.getState().colorMapping);
    });
  }
  componentWillUnmount() {
    this.unsubscribe();
  }
  componentDidUpdate(prevProps) {
    if (!(0, _lodash.isEqual)(prevProps.model, this.props.model)) {
      this.store.dispatch((0, _color_mapping.updateModel)(this.props.model));
    }
  }
  render() {
    const {
      palettes,
      data,
      isDarkMode,
      specialTokens,
      formatter,
      allowCustomMatch
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: this.store,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_container.Container, {
      palettes: palettes,
      data: data,
      isDarkMode: isDarkMode,
      specialTokens: specialTokens,
      formatter: formatter,
      allowCustomMatch: allowCustomMatch,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 9
      }
    }));
  }
}
exports.CategoricalColorMapping = CategoricalColorMapping;