"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.FindingsVulnerabilityFlyoutHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _i18nReact = require("@kbn/i18n-react");
var _test_subjects = require("../../test_subjects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/vulnerabilities/vulnerabilities_finding_flyout/vulnerability_finding_right/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EMPTY_VALUE = '-';
const FindingsVulnerabilityFlyoutHeader = ({
  finding
}) => {
  var _finding$observer, _vulnerability$score, _vulnerability$score2, _vulnerability$data_s, _vulnerability$data_s2, _vulnerability$data_s3;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const vulnerability = finding === null || finding === void 0 ? void 0 : finding.vulnerability;
  const vendor = finding === null || finding === void 0 ? void 0 : (_finding$observer = finding.observer) === null || _finding$observer === void 0 ? void 0 : _finding$observer.vendor;
  const renderCveBadge = () => {
    if (Array.isArray(vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id) && (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) > 1) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 45,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_CVE_BADGE,
        color: "subdued",
        css: (0, _react2.css)`
              border-radius: ${euiTheme.border.radius.small};
            `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 46,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.csp.vulnerabilities.vulnerabilityFindingFlyout.cveTooltip",
        defaultMessage: "+{value}",
        values: {
          value: (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) - 1
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 53,
          columnNumber: 13
        }
      })));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  };
  const renderCves = () => {
    if (!(vulnerability !== null && vulnerability !== void 0 && vulnerability.id) || (vulnerability === null || vulnerability === void 0 ? void 0 : vulnerability.id.length) === 0) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, EMPTY_VALUE);
    }
    const renderVulnerabilityId = () => {
      const id = Array.isArray(vulnerability.id) ? vulnerability.id[0] : vulnerability.id;
      const references = Array.isArray(vulnerability.reference) ? vulnerability.reference : [vulnerability.reference];
      const referenceLink = (0, _cloudSecurityPosture.findReferenceLink)(references, id);
      return referenceLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_REFERENCE_LINK,
        href: referenceLink,
        target: "_blank",
        color: "primary",
        css: (0, _react2.css)`
              display: flex;
              align-items: center;
              svg {
                width: ${euiTheme.base}px;
                height: ${euiTheme.base}px;
              }
            `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      }, id)) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        "data-test-subj": _test_subjects.VULNERABILITY_HEADER_ID,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 9
        }
      }, id);
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexStart",
      alignItems: "center",
      gutterSize: "xs",
      responsive: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
              line-height: ${euiTheme.size.xl};
            `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 11
      }
    }, renderVulnerabilityId())), renderCveBadge());
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_subjects.VULNERABILITY_SCORES_FLYOUT,
    style: {
      display: 'flex'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      height: '100%'
    },
    borderRadius: "m",
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 17
    }
  }, "CVSS")), vulnerability !== null && vulnerability !== void 0 && vulnerability.score ? /*#__PURE__*/_react.default.createElement(_cloudSecurityPosture.CVSScoreBadge, {
    version: vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$score = vulnerability.score) === null || _vulnerability$score === void 0 ? void 0 : _vulnerability$score.version,
    score: vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$score2 = vulnerability.score) === null || _vulnerability$score2 === void 0 ? void 0 : _vulnerability$score2.base,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 17
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 17
    }
  }, EMPTY_VALUE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      height: '100%'
    },
    borderRadius: "m",
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 17
    }
  }, "CVE")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, renderCves())))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_subjects.DATA_SOURCE_VULNERABILITY_FLYOUT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      height: '100%'
    },
    borderRadius: "m",
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 17
    }
  }, "Data source")), vulnerability !== null && vulnerability !== void 0 && (_vulnerability$data_s = vulnerability.data_source) !== null && _vulnerability$data_s !== void 0 && _vulnerability$data_s.URL ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: (_vulnerability$data_s2 = vulnerability.data_source) === null || _vulnerability$data_s2 === void 0 ? void 0 : _vulnerability$data_s2.URL,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 17
    }
  }, vulnerability === null || vulnerability === void 0 ? void 0 : (_vulnerability$data_s3 = vulnerability.data_source) === null || _vulnerability$data_s3 === void 0 ? void 0 : _vulnerability$data_s3.ID) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 17
    }
  }, EMPTY_VALUE)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    style: {
      height: '100%'
    },
    borderRadius: "m",
    paddingSize: "m",
    hasShadow: false,
    hasBorder: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("b", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 17
    }
  }, "Vendor")), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 15
    }
  }, vendor))))), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          margin: ${euiTheme.size.s};
        `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }));
};

// eslint-disable-next-line import/no-default-export
exports.FindingsVulnerabilityFlyoutHeader = FindingsVulnerabilityFlyoutHeader;
var _default = exports.default = FindingsVulnerabilityFlyoutHeader;