"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserToolTip = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _user_avatar = require("./user_avatar");
var _display_name = require("./display_name");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/user_profiles/user_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const UserFullInformation = /*#__PURE__*/_react.default.memo(({
  userInfo
}) => {
  var _userInfo$user;
  if (userInfo !== null && userInfo !== void 0 && (_userInfo$user = userInfo.user) !== null && _userInfo$user !== void 0 && _userInfo$user.full_name) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      className: "eui-textBreakWord",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("strong", {
      "data-test-subj": "user-profile-tooltip-full-name",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 22,
        columnNumber: 11
      }
    }, userInfo.user.full_name));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textBreakWord",
    "data-test-subj": "user-profile-tooltip-single-name",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  }, getNameOrMissingText(userInfo === null || userInfo === void 0 ? void 0 : userInfo.user)));
});
const getNameOrMissingText = user => {
  if (!user) {
    return i18n.MISSING_PROFILE;
  }
  return (0, _display_name.getName)(user);
};
UserFullInformation.displayName = 'UserFullInformation';
const UserToolTipAvatar = ({
  userInfo
}) => /*#__PURE__*/_react.default.createElement(_user_avatar.CaseUserAvatar, {
  size: 'm',
  userInfo: userInfo,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 23
  }
});
UserToolTipAvatar.displayName = 'UserToolTipAvatar';
const UserFullRepresentationComponent = ({
  userInfo
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "user-profile-tooltip-avatar",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(UserToolTipAvatar, {
    userInfo: userInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'column',
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(UserFullInformation, {
    userInfo: userInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  })), (userInfo === null || userInfo === void 0 ? void 0 : userInfo.user) && displayEmail(userInfo) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: "eui-textBreakWord",
    "data-test-subj": "user-profile-tooltip-email",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 15
    }
  }, userInfo.user.email)))));
};
UserFullRepresentationComponent.displayName = 'UserFullRepresentation';
const displayEmail = userInfo => {
  var _userInfo$user2, _userInfo$user3;
  return (userInfo === null || userInfo === void 0 ? void 0 : (_userInfo$user2 = userInfo.user) === null || _userInfo$user2 === void 0 ? void 0 : _userInfo$user2.full_name) && (userInfo === null || userInfo === void 0 ? void 0 : (_userInfo$user3 = userInfo.user) === null || _userInfo$user3 === void 0 ? void 0 : _userInfo$user3.email);
};
const UserToolTipComponent = ({
  children,
  userInfo
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    display: "inlineBlock",
    position: "top",
    content: /*#__PURE__*/_react.default.createElement(UserFullRepresentationComponent, {
      userInfo: userInfo,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 16
      }
    }),
    "data-test-subj": "user-profile-tooltip",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, children);
};
UserToolTipComponent.displayName = 'UserToolTip';
const UserToolTip = exports.UserToolTip = /*#__PURE__*/_react.default.memo(UserToolTipComponent);