"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditMenuWithContext = exports.EditMenu = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _reactRecompose = require("react-recompose");
var _clipboard = require("../../../lib/clipboard");
var _functional = require("../../../lib/aeroelastic/functional");
var _integration_utils = require("../../workpad_page/integration_utils");
var _elements = require("../../../state/actions/elements");
var _transient = require("../../../state/actions/transient");
var _workpad = require("../../../state/selectors/workpad");
var _element_handler_creators = require("../../../lib/element_handler_creators");
var _edit_menu = require("./edit_menu.component");
var _workpad2 = require("../../../routes/workpad");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/edit_menu/edit_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error untyped local
// @ts-expect-error untyped local
// @ts-expect-error untyped local
// @ts-expect-error untyped local
// @ts-expect-error untyped local
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const withGlobalState = (commit, updateGlobalState) => (type, payload) => {
  const newLayoutState = commit(type, payload);
  if (newLayoutState.currentScene.gestureEnd) {
    updateGlobalState(newLayoutState);
  }
};

/*
 * TODO: this is all copied from interactive_workpad_page and workpad_shortcuts
 */
const mapStateToProps = state => {
  const pageId = (0, _workpad.getSelectedPage)(state);
  const nodes = (0, _workpad.getNodes)(state, pageId);
  const selectedToplevelNodes = (0, _workpad.getSelectedToplevelNodes)(state);
  const selectedPrimaryShapeObjects = selectedToplevelNodes.map(id => nodes.find(s => s.id === id)).filter(shape => shape);
  const selectedPersistentPrimaryNodes = (0, _functional.flatten)(selectedPrimaryShapeObjects.map(shape => nodes.find(n => n.id === shape.id) // is it a leaf or a persisted group?
  ? [shape.id] : nodes.filter(s => s.position.parent === shape.id).map(s => s.id)));
  const selectedNodeIds = (0, _functional.flatten)(selectedPersistentPrimaryNodes.map((0, _integration_utils.crawlTree)(nodes)));
  const selectedNodes = selectedNodeIds.map(id => nodes.find(s => s.id === id)).filter(node => {
    return !!node;
  });
  return {
    pageId,
    selectedToplevelNodes,
    selectedNodes,
    state
  };
};
const mapDispatchToProps = dispatch => ({
  insertNodes: (selectedNodes, pageId) => dispatch((0, _elements.insertNodes)(selectedNodes, pageId)),
  removeNodes: (nodeIds, pageId) => dispatch((0, _elements.removeElements)(nodeIds, pageId)),
  selectToplevelNodes: nodes => dispatch((0, _transient.selectToplevelNodes)(nodes.filter(e => !e.position.parent).map(e => e.id))),
  elementLayer: (pageId, elementId, movement) => {
    dispatch((0, _elements.elementLayer)({
      pageId,
      elementId,
      movement
    }));
  },
  dispatch
});
const mergeProps = ({
  state,
  selectedToplevelNodes,
  ...restStateProps
}, {
  dispatch,
  ...restDispatchProps
}, {
  commit
}) => {
  const updateGlobalState = (0, _integration_utils.globalStateUpdater)(dispatch, state);
  return {
    ...restDispatchProps,
    ...restStateProps,
    commit: withGlobalState(commit, updateGlobalState),
    groupIsSelected: selectedToplevelNodes.length === 1 && selectedToplevelNodes[0].includes('group')
  };
};
const EditMenuWithContext = props => {
  const {
    undo,
    redo
  } = (0, _react.useContext)(_workpad2.WorkpadRoutingContext);
  return /*#__PURE__*/_react.default.createElement(_edit_menu.EditMenu, (0, _extends2.default)({}, props, {
    undoHistory: undo,
    redoHistory: redo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 10
    }
  }));
};
exports.EditMenuWithContext = EditMenuWithContext;
const EditMenu = exports.EditMenu = (0, _reactRecompose.compose)((0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps, mergeProps), (0, _reactRecompose.withProps)(() => ({
  hasPasteData: Boolean((0, _clipboard.getClipboardData)())
})), (0, _reactRecompose.withHandlers)(_element_handler_creators.basicHandlerCreators), (0, _reactRecompose.withHandlers)(_element_handler_creators.clipboardHandlerCreators), (0, _reactRecompose.withHandlers)(_element_handler_creators.layerHandlerCreators), (0, _reactRecompose.withHandlers)(_element_handler_creators.groupHandlerCreators), (0, _reactRecompose.withHandlers)(_element_handler_creators.alignmentDistributionHandlerCreators))(EditMenuWithContext);