"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditMenu = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _popover = require("../../popover");
var _shortcuts = require("../../../../i18n/shortcuts");
var _flatten_panel_tree = require("../../../lib/flatten_panel_tree");
var _custom_element_modal = require("../../custom_element_modal");
var _constants = require("../../../../common/lib/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/edit_menu/edit_menu.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const shortcutHelp = _shortcuts.ShortcutStrings.getShortcutHelp();
const strings = {
  getAlignmentMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.alignmentMenuItemLabel', {
    defaultMessage: 'Alignment',
    description: 'This refers to the vertical (i.e. left, center, right) and horizontal (i.e. top, middle, bottom) ' + 'alignment options of the selected elements'
  }),
  getBottomAlignMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.bottomAlignMenuItemLabel', {
    defaultMessage: 'Bottom'
  }),
  getCenterAlignMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.centerAlignMenuItemLabel', {
    defaultMessage: 'Center',
    description: 'This refers to alignment centered horizontally.'
  }),
  getCreateElementModalTitle: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.createElementModalTitle', {
    defaultMessage: 'Create new element'
  }),
  getDistributionMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.distributionMenutItemLabel', {
    defaultMessage: 'Distribution',
    description: 'This refers to the options to evenly spacing the selected elements horizontall or vertically.'
  }),
  getEditMenuButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.editMenuButtonLabel', {
    defaultMessage: 'Edit'
  }),
  getEditMenuLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.editMenuLabel', {
    defaultMessage: 'Edit options'
  }),
  getGroupMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.groupMenuItemLabel', {
    defaultMessage: 'Group',
    description: 'This refers to grouping multiple selected elements.'
  }),
  getHorizontalDistributionMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.horizontalDistributionMenutItemLabel', {
    defaultMessage: 'Horizontal'
  }),
  getLeftAlignMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.leftAlignMenuItemLabel', {
    defaultMessage: 'Left'
  }),
  getMiddleAlignMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.middleAlignMenuItemLabel', {
    defaultMessage: 'Middle',
    description: 'This refers to alignment centered vertically.'
  }),
  getOrderMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.orderMenuItemLabel', {
    defaultMessage: 'Order',
    description: 'Refers to the order of the elements displayed on the page from front to back'
  }),
  getRedoMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.redoMenuItemLabel', {
    defaultMessage: 'Redo'
  }),
  getRightAlignMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.rightAlignMenuItemLabel', {
    defaultMessage: 'Right'
  }),
  getSaveElementMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.savedElementMenuItemLabel', {
    defaultMessage: 'Save as new element'
  }),
  getTopAlignMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.topAlignMenuItemLabel', {
    defaultMessage: 'Top'
  }),
  getUndoMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.undoMenuItemLabel', {
    defaultMessage: 'Undo'
  }),
  getUngroupMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.ungroupMenuItemLabel', {
    defaultMessage: 'Ungroup',
    description: 'This refers to ungrouping a grouped element'
  }),
  getVerticalDistributionMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderEditMenu.verticalDistributionMenutItemLabel', {
    defaultMessage: 'Vertical'
  })
};
const EditMenu = ({
  cutNodes,
  copyNodes,
  pasteNodes,
  deleteNodes,
  cloneNodes,
  bringToFront,
  bringForward,
  sendBackward,
  sendToBack,
  alignLeft,
  alignCenter,
  alignRight,
  alignTop,
  alignMiddle,
  alignBottom,
  distributeHorizontally,
  distributeVertically,
  createCustomElement,
  selectedNodes,
  groupIsSelected,
  groupNodes,
  ungroupNodes,
  undoHistory,
  redoHistory,
  hasPasteData
}) => {
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const showModal = () => setModalVisible(true);
  const hideModal = () => setModalVisible(false);
  const handleSave = (name, description, image) => {
    createCustomElement(name, description, image);
    hideModal();
  };
  const editControl = togglePopover => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    "aria-label": strings.getEditMenuLabel(),
    onClick: togglePopover,
    "data-test-subj": "canvasWorkpadEditMenuButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 251,
      columnNumber: 5
    }
  }, strings.getEditMenuButtonLabel());
  const getPanelTree = closePopover => {
    const groupMenuItem = groupIsSelected ? {
      name: strings.getUngroupMenuItemLabel(),
      className: _constants.CONTEXT_MENU_TOP_BORDER_CLASSNAME,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "empty",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 266,
          columnNumber: 17
        }
      }),
      onClick: () => {
        ungroupNodes();
        closePopover();
      }
    } : {
      name: strings.getGroupMenuItemLabel(),
      className: _constants.CONTEXT_MENU_TOP_BORDER_CLASSNAME,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "empty",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 275,
          columnNumber: 17
        }
      }),
      disabled: selectedNodes.length < 2,
      onClick: () => {
        groupNodes();
        closePopover();
      }
    };
    const orderMenuItem = {
      name: strings.getOrderMenuItemLabel(),
      disabled: selectedNodes.length !== 1,
      // TODO: change to === 0 when we support relayering multiple elements
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "empty",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 286,
          columnNumber: 13
        }
      }),
      panel: {
        id: 1,
        title: strings.getOrderMenuItemLabel(),
        items: [{
          name: shortcutHelp.BRING_TO_FRONT,
          // TODO: check against current element position and disable if already top layer
          icon: 'sortUp',
          onClick: bringToFront
        }, {
          name: shortcutHelp.BRING_FORWARD,
          // TODO: same as above
          icon: 'arrowUp',
          onClick: bringForward
        }, {
          name: shortcutHelp.SEND_BACKWARD,
          // TODO: check against current element position and disable if already bottom layer
          icon: 'arrowDown',
          onClick: sendBackward
        }, {
          name: shortcutHelp.SEND_TO_BACK,
          // TODO: same as above
          icon: 'sortDown',
          onClick: sendToBack
        }]
      }
    };
    const alignmentMenuItem = {
      name: strings.getAlignmentMenuItemLabel(),
      className: 'canvasContextMenu',
      disabled: groupIsSelected || selectedNodes.length < 2,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "empty",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 319,
          columnNumber: 13
        }
      }),
      panel: {
        id: 2,
        title: strings.getAlignmentMenuItemLabel(),
        items: [{
          name: strings.getLeftAlignMenuItemLabel(),
          icon: 'editorItemAlignLeft',
          onClick: () => {
            alignLeft();
            closePopover();
          }
        }, {
          name: strings.getCenterAlignMenuItemLabel(),
          icon: 'editorItemAlignCenter',
          onClick: () => {
            alignCenter();
            closePopover();
          }
        }, {
          name: strings.getRightAlignMenuItemLabel(),
          icon: 'editorItemAlignRight',
          onClick: () => {
            alignRight();
            closePopover();
          }
        }, {
          name: strings.getTopAlignMenuItemLabel(),
          icon: 'editorItemAlignTop',
          onClick: () => {
            alignTop();
            closePopover();
          }
        }, {
          name: strings.getMiddleAlignMenuItemLabel(),
          icon: 'editorItemAlignMiddle',
          onClick: () => {
            alignMiddle();
            closePopover();
          }
        }, {
          name: strings.getBottomAlignMenuItemLabel(),
          icon: 'editorItemAlignBottom',
          onClick: () => {
            alignBottom();
            closePopover();
          }
        }]
      }
    };
    const distributionMenuItem = {
      name: strings.getDistributionMenuItemLabel(),
      className: 'canvasContextMenu',
      disabled: groupIsSelected || selectedNodes.length < 3,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "empty",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 380,
          columnNumber: 13
        }
      }),
      panel: {
        id: 3,
        title: strings.getAlignmentMenuItemLabel(),
        items: [{
          name: strings.getHorizontalDistributionMenuItemLabel(),
          icon: 'editorDistributeHorizontal',
          onClick: () => {
            distributeHorizontally();
            closePopover();
          }
        }, {
          name: strings.getVerticalDistributionMenuItemLabel(),
          icon: 'editorDistributeVertical',
          onClick: () => {
            distributeVertically();
            closePopover();
          }
        }]
      }
    };
    const savedElementMenuItem = {
      name: strings.getSaveElementMenuItemLabel(),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "indexOpen",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 407,
          columnNumber: 13
        }
      }),
      disabled: selectedNodes.length < 1,
      className: _constants.CONTEXT_MENU_TOP_BORDER_CLASSNAME,
      'data-test-subj': 'canvasWorkpadEditMenu__saveElementButton',
      onClick: () => {
        showModal();
        closePopover();
      }
    };
    const items = [{
      // TODO: check history and disable when there are no more changes to revert
      name: strings.getUndoMenuItemLabel(),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "editorUndo",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 421,
          columnNumber: 15
        }
      }),
      onClick: () => {
        undoHistory();
      }
    }, {
      // TODO: check history and disable when there are no more changes to reapply
      name: strings.getRedoMenuItemLabel(),
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "editorRedo",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 429,
          columnNumber: 15
        }
      }),
      onClick: () => {
        redoHistory();
      }
    }, {
      name: shortcutHelp.CUT,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "cut",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 436,
          columnNumber: 15
        }
      }),
      className: _constants.CONTEXT_MENU_TOP_BORDER_CLASSNAME,
      disabled: selectedNodes.length < 1,
      onClick: () => {
        cutNodes();
        closePopover();
      }
    }, {
      name: shortcutHelp.COPY,
      disabled: selectedNodes.length < 1,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "copy",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 447,
          columnNumber: 15
        }
      }),
      onClick: () => {
        copyNodes();
      }
    }, {
      name: shortcutHelp.PASTE,
      // TODO: can this be disabled if clipboard is empty?
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "copyClipboard",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 454,
          columnNumber: 15
        }
      }),
      disabled: !hasPasteData,
      onClick: () => {
        pasteNodes();
        closePopover();
      }
    }, {
      name: shortcutHelp.DELETE,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "trash",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 463,
          columnNumber: 15
        }
      }),
      disabled: selectedNodes.length < 1,
      onClick: () => {
        deleteNodes();
        closePopover();
      },
      'data-test-subj': 'canvasEditMenuDeleteButton'
    }, {
      name: shortcutHelp.CLONE,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "empty",
        size: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 473,
          columnNumber: 15
        }
      }),
      disabled: selectedNodes.length < 1,
      onClick: () => {
        cloneNodes();
        closePopover();
      }
    }, groupMenuItem, orderMenuItem, alignmentMenuItem, distributionMenuItem, savedElementMenuItem];
    return {
      id: 0,
      // title: strings.getEditMenuLabel(),
      items
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 495,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_popover.Popover, {
    button: editControl,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 496,
      columnNumber: 7
    }
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: (0, _flatten_panel_tree.flattenPanelTree)(getPanelTree(closePopover)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 498,
      columnNumber: 11
    }
  })), isModalVisible ? /*#__PURE__*/_react.default.createElement(_custom_element_modal.CustomElementModal, {
    title: strings.getCreateElementModalTitle(),
    onSave: handleSave,
    onCancel: hideModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 505,
      columnNumber: 9
    }
  }) : null);
};
exports.EditMenu = EditMenu;
EditMenu.propTypes = {
  cutNodes: _propTypes.default.func.isRequired,
  copyNodes: _propTypes.default.func.isRequired,
  pasteNodes: _propTypes.default.func.isRequired,
  deleteNodes: _propTypes.default.func.isRequired,
  cloneNodes: _propTypes.default.func.isRequired,
  bringToFront: _propTypes.default.func.isRequired,
  bringForward: _propTypes.default.func.isRequired,
  sendBackward: _propTypes.default.func.isRequired,
  sendToBack: _propTypes.default.func.isRequired,
  alignLeft: _propTypes.default.func.isRequired,
  alignCenter: _propTypes.default.func.isRequired,
  alignRight: _propTypes.default.func.isRequired,
  alignTop: _propTypes.default.func.isRequired,
  alignMiddle: _propTypes.default.func.isRequired,
  alignBottom: _propTypes.default.func.isRequired,
  distributeHorizontally: _propTypes.default.func.isRequired,
  distributeVertically: _propTypes.default.func.isRequired,
  createCustomElement: _propTypes.default.func.isRequired,
  selectedNodes: _propTypes.default.arrayOf(_propTypes.default.object).isRequired,
  groupIsSelected: _propTypes.default.bool.isRequired,
  groupNodes: _propTypes.default.func.isRequired,
  ungroupNodes: _propTypes.default.func.isRequired
};