"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadColorPicker = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _workpad = require("../../state/actions/workpad");
var _workpad2 = require("../../state/selectors/workpad");
var _color_picker_popover = require("../color_picker_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_color_picker/workpad_color_picker.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getBackgroundColorLabel: () => _i18n.i18n.translate('xpack.canvas.workpadConfig.backgroundColorLabel', {
    defaultMessage: 'Background color'
  })
};
const WorkpadColorPicker = props => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const onAddColor = (0, _react.useCallback)(payload => dispatch((0, _workpad.addColor)(payload)), [dispatch]);
  const onRemoveColor = (0, _react.useCallback)(payload => dispatch((0, _workpad.removeColor)(payload)), [dispatch]);
  const colors = (0, _reactRedux.useSelector)(_workpad2.getWorkpadColors);
  return /*#__PURE__*/_react.default.createElement(_color_picker_popover.ColorPickerPopover, (0, _extends2.default)({}, props, {
    onAddColor: onAddColor,
    onRemoveColor: onRemoveColor,
    colors: colors,
    hasButtons: true,
    ariaLabel: strings.getBackgroundColorLabel(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 5
    }
  }));
};
exports.WorkpadColorPicker = WorkpadColorPicker;
WorkpadColorPicker.propTypes = _color_picker_popover.ColorPickerPopover.propTypes;