"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _tag_list = require("../tag_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/element_card/element_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const tagType = 'badge';
const ElementCard = ({
  title,
  description,
  image,
  tags = [],
  onClick,
  ...rest
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiCard, (0, _extends2.default)({
  className: image ? 'canvasElementCard' : 'canvasElementCard canvasElementCard--hasIcon',
  textAlign: "left",
  title: title,
  description: description,
  footer: /*#__PURE__*/_react.default.createElement(_tag_list.TagList, {
    tags: tags,
    tagType: tagType,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }),
  image: image,
  icon: image ? undefined : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "canvasApp",
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 31
    }
  }),
  onClick: onClick
}, rest, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}));
exports.ElementCard = ElementCard;
ElementCard.propTypes = {
  title: _propTypes.default.string.isRequired,
  description: _propTypes.default.string.isRequired,
  image: _propTypes.default.string,
  onClick: _propTypes.default.func
};