"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.failedTransactionsCorrelationsTab = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _license_check = require("../../../../common/license_check");
var _use_license_context = require("../../../context/license/use_license_context");
var _license_prompt = require("../../shared/license_prompt");
var _failed_transactions_correlations = require("../correlations/failed_transactions_correlations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/failed_transactions_correlations_tab.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FailedTransactionsCorrelationsTab({
  onFilter
}) {
  const license = (0, _use_license_context.useLicenseContext)();
  const hasActivePlatinumLicense = (0, _license_check.isActivePlatinumLicense)(license);
  const metric = {
    app: 'apm',
    metric: hasActivePlatinumLicense ? 'failed_transactions_tab_view' : 'failed_transactions_license_prompt',
    metricType: _public.METRIC_TYPE.COUNT
  };
  (0, _public.useTrackMetric)(metric);
  (0, _public.useTrackMetric)({
    ...metric,
    delay: 15000
  });
  return hasActivePlatinumLicense ? /*#__PURE__*/_react.default.createElement(_failed_transactions_correlations.FailedTransactionsCorrelations, {
    onFilter: onFilter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
    text: _i18n.i18n.translate('xpack.apm.failedTransactionsCorrelations.licenseCheckText', {
      defaultMessage: `To use the failed transaction correlations feature, you must be subscribed to an Elastic Platinum license. With it, you'll be able to discover which attributes are contributing to failed transactions.`
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  });
}
const failedTransactionsCorrelationsTab = exports.failedTransactionsCorrelationsTab = {
  dataTestSubj: 'apmFailedTransactionsCorrelationsTabButton',
  key: 'failedTransactionsCorrelations',
  label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.transactionDetails.tabs.failedTransactionsCorrelationsLabel', {
    defaultMessage: 'Failed transaction correlations'
  })),
  component: FailedTransactionsCorrelationsTab
};