"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeysNotEnabled = ApiKeysNotEnabled;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_keys/prompts/api_keys_not_enabled.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ApiKeysNotEnabled() {
  const {
    services: {
      docLinks
    }
  } = (0, _public.useKibana)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 21,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.settings.agentKeys.apiKeysDisabledErrorTitle', {
      defaultMessage: 'API keys not enabled in Elasticsearch'
    })),
    iconType: "warning",
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 29,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.apm.settings.agentKeys.apiKeysDisabledErrorDescription",
      defaultMessage: "Contact your system administrator and refer to the {link} to enable API keys.",
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "apmApiKeysNotEnabledDocsLink",
          href: docLinks === null || docLinks === void 0 ? void 0 : docLinks.links.security.apiKeyServiceSettings,
          target: "_blank",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 35,
            columnNumber: 17
          }
        }, _i18n.i18n.translate('xpack.apm.settings.agentKeys.apiKeysDisabledErrorLinkText', {
          defaultMessage: 'docs'
        }))
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 30,
        columnNumber: 11
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 19,
      columnNumber: 5
    }
  });
}