"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceOverviewInstancesTable = ServiceOverviewInstancesTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _service_overview_instances_chart_and_table = require("../service_overview_instances_chart_and_table");
var _overview_table_container = require("../../../shared/overview_table_container");
var _get_columns = require("./get_columns");
var _intance_details = require("./intance_details");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_breakpoints = require("../../../../hooks/use_breakpoints");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_overview/service_overview_instances_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServiceOverviewInstancesTable({
  mainStatsItems = [],
  mainStatsItemCount,
  serviceName,
  mainStatsStatus: status,
  tableOptions,
  onChangeTableOptions,
  detailedStatsLoading,
  detailedStatsData: detailedStatsData,
  isLoading,
  isNotInitiated
}) {
  const {
    query,
    query: {
      kuery,
      latencyAggregationType,
      comparisonEnabled,
      offset
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}');
  const [itemIdToOpenActionMenuRowMap, setItemIdToOpenActionMenuRowMap] = (0, _react.useState)({});
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  (0, _react.useEffect)(() => {
    // Closes any open rows when fetching new items
    setItemIdToExpandedRowMap({});
  }, [status]);
  const {
    pageIndex,
    sort
  } = tableOptions;
  const {
    direction,
    field
  } = sort;
  const toggleRowActionMenu = selectedServiceNodeName => {
    const actionMenuRowMapValues = {
      ...itemIdToOpenActionMenuRowMap
    };
    if (actionMenuRowMapValues[selectedServiceNodeName]) {
      delete actionMenuRowMapValues[selectedServiceNodeName];
    } else {
      actionMenuRowMapValues[selectedServiceNodeName] = true;
    }
    setItemIdToOpenActionMenuRowMap(actionMenuRowMapValues);
  };
  const toggleRowDetails = selectedServiceNodeName => {
    const expandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (expandedRowMapValues[selectedServiceNodeName]) {
      delete expandedRowMapValues[selectedServiceNodeName];
    } else {
      expandedRowMapValues[selectedServiceNodeName] = /*#__PURE__*/_react.default.createElement(_intance_details.InstanceDetails, {
        serviceNodeName: selectedServiceNodeName,
        serviceName: serviceName,
        kuery: kuery,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 102,
          columnNumber: 9
        }
      });
    }
    setItemIdToExpandedRowMap(expandedRowMapValues);
  };

  // Hide the spark plots if we're below 1600 px
  const {
    isXl
  } = (0, _use_breakpoints.useBreakpoints)();
  const shouldShowSparkPlots = !isXl;
  const columns = (0, _get_columns.getColumns)({
    serviceName,
    kuery,
    latencyAggregationType: latencyAggregationType,
    detailedStatsLoading,
    detailedStatsData,
    comparisonEnabled,
    toggleRowDetails,
    itemIdToExpandedRowMap,
    toggleRowActionMenu,
    itemIdToOpenActionMenuRowMap,
    shouldShowSparkPlots,
    offset,
    query
  });
  const pagination = {
    pageIndex,
    pageSize: _service_overview_instances_chart_and_table.PAGE_SIZE,
    totalItemCount: mainStatsItemCount,
    showPerPageOptions: false
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "serviceOverviewInstancesTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTableTitle', {
    defaultMessage: 'Top {count} {count, plural, one {instance} other {instances}}',
    values: {
      count: mainStatsItemCount
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "serviceInstancesTableContainer",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_table_container.OverviewTableContainer, {
    fixedHeight: true,
    isEmptyAndNotInitiated: mainStatsItemCount === 0 && isNotInitiated,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    noItemsMessage: status === _use_fetcher.FETCH_STATUS.LOADING ? _i18n.i18n.translate('xpack.apm.serviceOverview.loadingText', {
      defaultMessage: 'Loading…'
    }) : _i18n.i18n.translate('xpack.apm.serviceOverview.noResultsText', {
      defaultMessage: 'No instances found'
    }),
    "data-test-subj": "instancesTable",
    loading: isLoading,
    items: mainStatsItems,
    columns: columns,
    pagination: pagination,
    sorting: {
      sort: {
        field,
        direction
      }
    },
    onChange: onChangeTableOptions,
    itemId: "serviceNodeName",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? _i18n.i18n.translate('xpack.apm.serviceOverview.instancesTable.errorMessage', {
      defaultMessage: 'Failed to fetch'
    }) : '',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }))));
}