"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FallbackCorrelationBadge = FallbackCorrelationBadge;
exports.LatencyCorrelations = LatencyCorrelations;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _field_stats_popover = require("./context_popover/field_stats_popover");
var _formatters = require("../../../../common/utils/formatters");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _duration_distribution_chart = require("../../shared/charts/duration_distribution_chart");
var _total_doc_count_label = require("../../shared/charts/duration_distribution_chart/total_doc_count_label");
var _url_helpers = require("../../shared/links/url_helpers");
var _correlations_table = require("./correlations_table");
var _latency_correlations_help_popover = require("./latency_correlations_help_popover");
var _get_overall_histogram = require("./utils/get_overall_histogram");
var _empty_state_prompt = require("./empty_state_prompt");
var _cross_cluster_search_warning = require("./cross_cluster_search_warning");
var _progress_controls = require("./progress_controls");
var _use_latency_correlations = require("./use_latency_correlations");
var _get_transaction_distribution_chart_data = require("./get_transaction_distribution_chart_data");
var _chart_title_tool_tip = require("./chart_title_tool_tip");
var _get_failed_transactions_correlation_impact_label = require("./utils/get_failed_transactions_correlation_impact_label");
var _duration_distribution_chart_with_scrubber = require("../../shared/charts/duration_distribution_chart_with_scrubber");
var _open_in_discover_button = require("../../shared/links/discover_links/open_in_discover_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/correlations/latency_correlations.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function FallbackCorrelationBadge() {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.correlations.latencyCorrelations.fallbackCorrelationBadgeMessage",
    defaultMessage: "Very low",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 7
    }
  }));
}
function LatencyCorrelations({
  onFilter
}) {
  var _response$percentileT;
  const {
    core: {
      notifications
    }
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    progress,
    response,
    startFetch,
    cancelFetch
  } = (0, _use_latency_correlations.useLatencyCorrelations)();
  const {
    overallHistogram,
    hasData,
    status
  } = (0, _get_overall_histogram.getOverallHistogram)(response, progress.isRunning);
  (0, _react.useEffect)(() => {
    if (progress.error) {
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.errorTitle', {
          defaultMessage: 'An error occurred fetching correlations'
        }),
        text: progress.error
      });
    }
  }, [progress.error, notifications.toasts]);
  const [pinnedSignificantTerm, setPinnedSignificantTerm] = (0, _react.useState)(null);
  const [selectedSignificantTerm, setSelectedSignificantTerm] = (0, _react.useState)(null);
  const history = (0, _reactRouterDom.useHistory)();
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const onAddFilter = (0, _react.useCallback)(({
    fieldName,
    fieldValue,
    include
  }) => {
    if (include) {
      (0, _url_helpers.push)(history, {
        query: {
          kuery: `${fieldName}:"${fieldValue}"`
        }
      });
      trackApmEvent({
        metric: 'correlations_term_include_filter'
      });
    } else {
      (0, _url_helpers.push)(history, {
        query: {
          kuery: `not ${fieldName}:"${fieldValue}"`
        }
      });
      trackApmEvent({
        metric: 'correlations_term_exclude_filter'
      });
    }
    onFilter();
  }, [onFilter, history, trackApmEvent]);
  const mlCorrelationColumns = (0, _react.useMemo)(() => [{
    width: '116px',
    field: 'correlation',
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.correlationLabel', {
      defaultMessage: 'Correlation'
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.correlationColumnDescription', {
        defaultMessage: 'The correlation score [0-1] of an attribute; the greater the score, the more an attribute increases latency.'
      }),
      size: "s",
      color: "subdued",
      type: "question",
      className: "eui-alignTop",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 13
      }
    })),
    render: (_, {
      correlation
    }) => {
      return /*#__PURE__*/_react.default.createElement("div", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 150,
          columnNumber: 18
        }
      }, (0, _formatters.asPreciseDecimal)(correlation, 2));
    },
    sortable: true
  }, {
    width: '116px',
    field: 'pValue',
    name: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.apm.correlations.failedTransactions.correlationsTable.impactLabel', {
      defaultMessage: 'Impact'
    })),
    render: (_, {
      correlation,
      isFallbackResult
    }) => {
      const label = (0, _get_failed_transactions_correlation_impact_label.getLatencyCorrelationImpactLabel)(correlation, isFallbackResult);
      return label ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: label.color,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 26
        }
      }, label.impact) : null;
    },
    sortable: true
  }, {
    field: 'fieldName',
    name: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.fieldNameLabel', {
      defaultMessage: 'Field name'
    }),
    render: (_, {
      fieldName,
      fieldValue
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, fieldName, /*#__PURE__*/_react.default.createElement(_field_stats_popover.FieldStatsPopover, {
      fieldName: fieldName,
      fieldValue: fieldValue,
      onAddFilter: onAddFilter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 13
      }
    })),
    sortable: true
  }, {
    field: 'fieldValue',
    name: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.fieldValueLabel', {
      defaultMessage: 'Field value'
    }),
    render: (_, {
      fieldValue
    }) => String(fieldValue).slice(0, 50),
    sortable: true
  }, {
    width: '100px',
    actions: [{
      name: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.filterLabel', {
        defaultMessage: 'Filter'
      }),
      description: ({
        fieldName
      }) => _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.filterDescription', {
        defaultMessage: 'Filter by {fieldName}',
        values: {
          fieldName
        }
      }),
      icon: 'plusInCircle',
      type: 'icon',
      onClick: ({
        fieldName,
        fieldValue
      }) => onAddFilter({
        fieldName,
        fieldValue,
        include: true
      })
    }, {
      name: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.excludeLabel', {
        defaultMessage: 'Exclude'
      }),
      description: ({
        fieldName
      }) => _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.excludeDescription', {
        defaultMessage: 'Filter out {fieldName}',
        values: {
          fieldName
        }
      }),
      icon: 'minusInCircle',
      type: 'icon',
      onClick: ({
        fieldName,
        fieldValue
      }) => onAddFilter({
        fieldName,
        fieldValue,
        include: false
      })
    }],
    name: _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.correlationsTable.actionsLabel', {
      defaultMessage: 'Filter'
    })
  }], [onAddFilter]);
  const [sortField, setSortField] = (0, _react.useState)('correlation');
  const [sortDirection, setSortDirection] = (0, _react.useState)('desc');
  const onTableChange = (0, _react.useCallback)(({
    sort
  }) => {
    const {
      field: currentSortField,
      direction: currentSortDirection
    } = sort;
    setSortField(currentSortField);
    setSortDirection(currentSortDirection);
  }, []);
  const sorting = {
    sort: {
      field: sortField,
      direction: sortDirection
    }
  };
  const histogramTerms = (0, _react.useMemo)(() => {
    var _response$latencyCorr;
    return (0, _lodash.orderBy)((_response$latencyCorr = response.latencyCorrelations) !== null && _response$latencyCorr !== void 0 ? _response$latencyCorr : [], sortField, sortDirection);
  }, [response.latencyCorrelations, sortField, sortDirection]);
  const selectedHistogram = (0, _react.useMemo)(() => {
    if (!histogramTerms) {
      return;
    } else if (selectedSignificantTerm) {
      return histogramTerms === null || histogramTerms === void 0 ? void 0 : histogramTerms.find(h => h.fieldName === selectedSignificantTerm.fieldName && h.fieldValue === selectedSignificantTerm.fieldValue);
    } else if (pinnedSignificantTerm) {
      return histogramTerms.find(h => h.fieldName === pinnedSignificantTerm.fieldName && h.fieldValue === pinnedSignificantTerm.fieldValue);
    }
    return histogramTerms[0];
  }, [histogramTerms, pinnedSignificantTerm, selectedSignificantTerm]);
  const showCorrelationsTable = progress.isRunning || histogramTerms.length > 0;
  const showCorrelationsEmptyStatePrompt = histogramTerms.length < 1 && (progress.loaded === 1 || !progress.isRunning);
  const transactionDistributionChartData = (0, _get_transaction_distribution_chart_data.getTransactionDistributionChartData)({
    euiTheme,
    allTransactionsHistogram: overallHistogram,
    selectedTerm: selectedHistogram
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmLatencyCorrelationsTabContent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    style: {
      minHeight: _duration_distribution_chart_with_scrubber.MIN_TAB_TITLE_HEIGHT
    },
    alignItems: "center",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 302,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 303,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 304,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "apmCorrelationsLatencyCorrelationsChartTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 305,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.panelTitle', {
    defaultMessage: 'Latency distribution'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 313,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_title_tool_tip.ChartTitleToolTip, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_total_doc_count_label.TotalDocCountLabel, {
    eventType: _common.ProcessorEvent.transaction,
    totalDocCount: response.totalDocCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 324,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_open_in_discover_button.OpenInDiscoverButton, {
    dataTestSubj: "apmLatencyCorrelationsOpenInDiscoverButton",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 325,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_latency_correlations_help_popover.LatencyCorrelationsHelpPopover, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 333,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_duration_distribution_chart.DurationDistributionChart, {
    markerValue: (_response$percentileT = response.percentileThresholdValue) !== null && _response$percentileT !== void 0 ? _response$percentileT : 0,
    data: transactionDistributionChartData,
    hasData: hasData,
    status: status,
    eventType: _common.ProcessorEvent.transaction,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 343,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 345,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    "data-test-subj": "apmCorrelationsLatencyCorrelationsTablePanelTitle",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.correlations.latencyCorrelations.tableTitle', {
    defaultMessage: 'Correlations'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_progress_controls.CorrelationsProgressControls, {
    progress: progress.loaded,
    isRunning: progress.isRunning,
    onRefresh: startFetch,
    onCancel: cancelFetch,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 355,
      columnNumber: 7
    }
  }), response.ccsWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 364,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_cross_cluster_search_warning.CrossClusterSearchCompatibilityWarning, {
    version: "7.14",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 366,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "apmCorrelationsTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 7
    }
  }, showCorrelationsTable && /*#__PURE__*/_react.default.createElement(_correlations_table.CorrelationsTable, {
    columns: mlCorrelationColumns,
    rowHeader: "correlation",
    significantTerms: histogramTerms,
    status: progress.isRunning ? _use_fetcher.FETCH_STATUS.LOADING : _use_fetcher.FETCH_STATUS.SUCCESS,
    setPinnedSignificantTerm: setPinnedSignificantTerm,
    setSelectedSignificantTerm: setSelectedSignificantTerm,
    selectedTerm: selectedHistogram,
    onTableChange: onTableChange,
    sorting: sorting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 374,
      columnNumber: 11
    }
  }), showCorrelationsEmptyStatePrompt && /*#__PURE__*/_react.default.createElement(_empty_state_prompt.CorrelationsEmptyStatePrompt, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 386,
      columnNumber: 46
    }
  })));
}