"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsTable = CorrelationsTable;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/correlations/correlations_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGINATION_SIZE_OPTIONS = [5, 10, 20, 50];
function CorrelationsTable({
  significantTerms,
  status,
  setPinnedSignificantTerm,
  setSelectedSignificantTerm,
  columns,
  selectedTerm,
  onTableChange,
  sorting,
  rowHeader
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const trackApmEvent = (0, _public.useUiTracker)({
    app: 'apm'
  });
  const trackSelectSignificantCorrelationTerm = (0, _react.useCallback)(() => (0, _lodash.debounce)(() => trackApmEvent({
    metric: 'select_significant_term'
  }), 1000), [trackApmEvent]);
  const [pageIndex, setPageIndex] = (0, _react.useState)(0);
  const [pageSize, setPageSize] = (0, _react.useState)(10);
  const {
    pagination,
    pageOfItems
  } = (0, _react.useMemo)(() => {
    var _significantTerms$len;
    const pageStart = pageIndex * pageSize;
    const itemCount = (_significantTerms$len = significantTerms === null || significantTerms === void 0 ? void 0 : significantTerms.length) !== null && _significantTerms$len !== void 0 ? _significantTerms$len : 0;
    return {
      pageOfItems: significantTerms === null || significantTerms === void 0 ? void 0 : significantTerms.slice(pageStart, pageStart + pageSize),
      pagination: {
        pageIndex,
        pageSize,
        totalItemCount: itemCount,
        pageSizeOptions: PAGINATION_SIZE_OPTIONS
      }
    };
  }, [pageIndex, pageSize, significantTerms]);
  const onChange = (0, _react.useCallback)(tableSettings => {
    const {
      index,
      size
    } = tableSettings.page;
    setPageIndex(index);
    setPageSize(size);
    onTableChange(tableSettings);
  }, [onTableChange]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: pageOfItems !== null && pageOfItems !== void 0 ? pageOfItems : [],
    noItemsMessage: status === _use_fetcher.FETCH_STATUS.LOADING ? loadingText : noDataText,
    loading: status === _use_fetcher.FETCH_STATUS.LOADING,
    error: status === _use_fetcher.FETCH_STATUS.FAILURE ? errorMessage : '',
    columns: columns,
    rowHeader: rowHeader,
    rowProps: term => {
      return {
        onClick: () => {
          if (setPinnedSignificantTerm) {
            setPinnedSignificantTerm(term);
          }
        },
        onMouseEnter: () => {
          setSelectedSignificantTerm(term);
          trackSelectSignificantCorrelationTerm();
        },
        onMouseLeave: () => setSelectedSignificantTerm(null),
        style: selectedTerm && selectedTerm.fieldValue === term.fieldValue && selectedTerm.fieldName === term.fieldName ? {
          backgroundColor: euiTheme.colors.lightestShade
        } : null
      };
    },
    pagination: pagination,
    onChange: onChange,
    sorting: sorting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  });
}
const loadingText = _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.loadingText', {
  defaultMessage: 'Loading...'
});
const noDataText = _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.noDataText', {
  defaultMessage: 'No data'
});
const errorMessage = _i18n.i18n.translate('xpack.apm.correlations.correlationsTable.errorMessage', {
  defaultMessage: 'Failed to fetch'
});