"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findBackfillQuerySchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const findBackfillQuerySchema = exports.findBackfillQuerySchema = _configSchema.schema.object({
  end: _configSchema.schema.maybe(_configSchema.schema.string()),
  page: _configSchema.schema.number({
    defaultValue: 1,
    min: 1
  }),
  perPage: _configSchema.schema.number({
    defaultValue: 10,
    min: 0
  }),
  ruleIds: _configSchema.schema.maybe(_configSchema.schema.string()),
  start: _configSchema.schema.maybe(_configSchema.schema.string()),
  sortField: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('createdAt'), _configSchema.schema.literal('start')])),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')]))
}, {
  validate({
    start,
    end
  }) {
    if (start) {
      const parsedStart = Date.parse(start);
      if (isNaN(parsedStart)) {
        return `[start]: query start must be valid date`;
      }
    }
    if (end) {
      const parsedEnd = Date.parse(end);
      if (isNaN(parsedEnd)) {
        return `[end]: query end must be valid date`;
      }
    }
  }
});