"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAppMockRenderer = void 0;
var _react = _interopRequireDefault(require("react"));
var _rxjs = require("rxjs");
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@testing-library/react");
var _mocks = require("@kbn/core/public/mocks");
var _mocks2 = require("@kbn/licensing-plugin/public/mocks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/alerting/public/lib/test_utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable no-console */

const createAppMockRenderer = ({
  capabilities,
  license
} = {}) => {
  const licensingPluginMock = _mocks2.licensingMock.createStart();
  const queryClient = new _reactQuery.QueryClient({
    defaultOptions: {
      queries: {
        retry: false
      }
    },
    /**
     * React query prints the errors in the console even though
     * all tests are passings. We turn them off for testing.
     */
    logger: {
      log: console.log,
      warn: console.warn,
      error: () => {}
    }
  });
  const mockedSetBadge = jest.fn();
  const core = _mocks.coreMock.createStart();
  const services = {
    ...core,
    application: {
      ...core.application,
      capabilities: {
        ...core.application.capabilities,
        ...capabilities
      }
    },
    licensing: license != null ? {
      ...licensingPluginMock,
      license$: new _rxjs.BehaviorSubject(license)
    } : licensingPluginMock,
    chrome: {
      ...core.chrome,
      setBadge: mockedSetBadge
    }
  };
  const AppWrapper = /*#__PURE__*/_react.default.memo(({
    children
  }) => core.rendering.addContext(/*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 9
    }
  }, children))));
  AppWrapper.displayName = 'AppWrapper';
  const render = (ui, options) => {
    return (0, _react2.render)(ui, {
      wrapper: AppWrapper,
      ...options
    });
  };
  return {
    coreStart: services,
    render,
    queryClient,
    AppWrapper,
    mocked: {
      setBadge: mockedSetBadge
    }
  };
};
exports.createAppMockRenderer = createAppMockRenderer;