"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.streamEndFactory = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Helper function that will check if the actual stream is still running
 * and only then will call the callback to end the raw stream and update its state.
 * This is implemented as a factory that receives the necessary dependencies
 * which then returns the actual helper function.
 */
const streamEndFactory = (stateHandler, streamEndCallback, logDebugMessage) => {
  return function end() {
    if (stateHandler.isRunning()) {
      stateHandler.isRunning(false);
      logDebugMessage('Ending analysis.');
      streamEndCallback();
    } else {
      logDebugMessage('end() was called again with isRunning already being false.');
    }
  };
};
exports.streamEndFactory = streamEndFactory;