"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChangePointTypeFilter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlIsDefined = require("@kbn/ml-is-defined");
var _constants = require("./constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/aiops/public/components/change_point_detection/change_point_type_filter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const changePointTypes = [{
  value: _constants.CHANGE_POINT_TYPES.DIP,
  description: _i18n.i18n.translate('xpack.aiops.changePointDetection.dipDescription', {
    defaultMessage: 'A significant dip occurs at this point.'
  })
}, {
  value: _constants.CHANGE_POINT_TYPES.SPIKE,
  description: _i18n.i18n.translate('xpack.aiops.changePointDetection.spikeDescription', {
    defaultMessage: 'A significant spike occurs at this point.'
  })
}, {
  value: _constants.CHANGE_POINT_TYPES.DISTRIBUTION_CHANGE,
  description: _i18n.i18n.translate('xpack.aiops.changePointDetection.distributionChangeDescription', {
    defaultMessage: 'The overall distribution of the values has changed significantly.'
  })
}, {
  value: _constants.CHANGE_POINT_TYPES.STEP_CHANGE,
  description: _i18n.i18n.translate('xpack.aiops.changePointDetection.stepChangeDescription', {
    defaultMessage: 'The change indicates a statistically significant step up or down in value distribution.'
  })
}, {
  value: _constants.CHANGE_POINT_TYPES.TREND_CHANGE,
  description: _i18n.i18n.translate('xpack.aiops.changePointDetection.trendChangeDescription', {
    defaultMessage: 'An overall trend change occurs at this point.'
  })
}];
const ChangePointTypeFilter = ({
  value,
  onChange
}) => {
  const options = (0, _react.useMemo)(() => {
    return [{
      value: undefined,
      description: ''
    }, ...changePointTypes].map(v => {
      var _v$value;
      return {
        value: v.value,
        label: (_v$value = v.value) !== null && _v$value !== void 0 ? _v$value : _i18n.i18n.translate('xpack.aiops.changePointDetection.selectAllChangePoints', {
          defaultMessage: 'Select all'
        }),
        description: v.description
      };
    });
  }, []);
  const selection = !value ? [options[0]] : options.filter(v => value.includes(v.value));
  const onChangeCallback = (0, _react.useCallback)(selectedOptions => {
    if (selectedOptions.length === 0 || selectedOptions[selectedOptions.length - 1].value === undefined) {
      onChange(undefined);
      return;
    }
    onChange(selectedOptions.map(v => v.value).filter(_mlIsDefined.isDefined));
  }, [onChange]);
  const renderOption = (0, _react.useCallback)(option => {
    const {
      label,
      description
    } = option;
    if (!description) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "left",
      content: description,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: 's',
      alignItems: 'center',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "info",
      color: 'primary',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 11
      }
    }, label)));
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.aiops.changePointDetection.changePointTypeLabel', {
      defaultMessage: 'Change point type'
    }),
    display: 'columnCompressed',
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: options,
    selectedOptions: selection,
    onChange: onChangeCallback,
    isClearable: true,
    "data-test-subj": "aiopsChangePointTypeFilter",
    renderOption: renderOption,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 7
    }
  }));
};
exports.ChangePointTypeFilter = ChangePointTypeFilter;