"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listTypes = listTypes;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _schemas = require("./schemas");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function listTypes(context, options) {
  try {
    _schemas.listTypesParamsSchema.validate(options);
  } catch (error) {
    throw _boom.default.badRequest(`Error validating params - ${error.message}`);
  }
  const {
    featureId,
    includeSystemActionTypes
  } = options;
  const connectorTypes = context.actionTypeRegistry.list(featureId);
  const filteredConnectorTypes = includeSystemActionTypes ? connectorTypes : connectorTypes.filter(type => !type.isSystemActionType);
  return filteredConnectorTypes;
}