"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiCollapsibleNavAccordionStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../../global_styling");
var _collapsible_nav_item = require("./collapsible_nav_item.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiCollapsibleNavAccordionStyles = exports.euiCollapsibleNavAccordionStyles = function euiCollapsibleNavAccordionStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var sharedStyles = (0, _collapsible_nav_item.euiCollapsibleNavItemVariables)(euiThemeContext);
  return {
    // NOTE: Specific usage of `>`s selectors are important here, because accordions can be nested
    // - just because a parent accordion is open or selected does not mean its child accordion is the same
    euiCollapsibleNavAccordion: /*#__PURE__*/(0, _react.css)(".euiAccordion__button{overflow:hidden;}&>.euiAccordion__triggerWrapper{border-radius:", sharedStyles.borderRadius, ";overflow:hidden;", _global_styling.euiCanAnimate, "{transition:background-color ", sharedStyles.animation, ";}&:hover,&:focus-within{background-color:", sharedStyles.backgroundHoverColor, ";.euiAccordion__arrow .euiIcon{color:", sharedStyles.color, ";}}&:has(:focus-visible){outline-style:auto;outline-offset:-", euiTheme.focus.width, ";*:focus{outline:none;}}}.euiAccordion__buttonContent{", (0, _global_styling.logicalCSS)('max-width', '100%'), " flex-basis:100%;display:flex;align-items:center;}.euiCollapsibleNavLink{", (0, _global_styling.logicalCSS)('width', '100%'), ";};label:euiCollapsibleNavAccordion;"),
    isSelected: /*#__PURE__*/(0, _react.css)("&>.euiAccordion__triggerWrapper{background-color:", sharedStyles.backgroundSelectedColor, ";&:hover,&:focus-within{background-color:", sharedStyles.backgroundSelectedColor, ";}};label:isSelected;"),
    isTopItem: /*#__PURE__*/(0, _react.css)("margin:", sharedStyles.padding, ";;label:isTopItem;"),
    isSubItem: /*#__PURE__*/(0, _react.css)("&.euiAccordion-isOpen .euiAccordion__children::after{content:'';display:block;", (0, _global_styling.logicalCSS)('height', euiTheme.size.m), ";};label:isSubItem;"),
    // Arrow element
    euiCollapsibleNavAccordion__arrow: /*#__PURE__*/(0, _react.css)("margin:0;", (0, _global_styling.logicalCSS)('height', sharedStyles.height), (0, _global_styling.logicalCSS)('width', euiTheme.size.xl), "transform:none!important;&>.euiIcon{color:", sharedStyles.rightIconColor, ";transform:rotate(90deg);", _global_styling.euiCanAnimate, "{transition:transform ", sharedStyles.animation, ",color ", sharedStyles.animation, ";}}&.euiAccordion__arrow[aria-expanded='true']>.euiIcon{color:", sharedStyles.color, ";transform:rotate(-90deg);}&:hover,&:focus{background-color:transparent;};label:euiCollapsibleNavAccordion__arrow;")
  };
};