"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _discover_router = require("./discover_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const renderApp = ({
  element,
  onAppLeave,
  services,
  customizationContext
}) => {
  const {
    capabilities,
    chrome,
    data,
    core
  } = services;
  if (!capabilities.discover_v2.save) {
    chrome.setBadge({
      text: _i18n.i18n.translate('discover.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('discover.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save Discover sessions'
      }),
      iconType: 'glasses'
    });
  }
  const unmount = (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_discover_router.DiscoverRouter, {
    onAppLeave: onAppLeave,
    services: services,
    customizationContext: customizationContext,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }), core)(element);
  return () => {
    unmount();
    data.search.session.clear();
  };
};
exports.renderApp = renderApp;