"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataDriftView = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _aiopsComponents = require("@kbn/aiops-components");
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _mlInMemoryTable = require("@kbn/ml-in-memory-table");
var _mlIsPopulatedObject = require("@kbn/ml-is-populated-object");
var _field_types_utils = require("../common/util/field_types_utils");
var _use_data_drift_result = require("./use_data_drift_result");
var _data_drift_overview_table = require("./data_drift_overview_table");
var _data_drift_hint = require("./data_drift_hint");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/data_drift/data_drift_view.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const showOnlyDriftedFieldsOptionLabel = _i18n.i18n.translate('xpack.dataVisualizer.dataDrift.showOnlyDriftedFieldsOptionLabel', {
  defaultMessage: 'Show only fields with drifted data'
});
// Data drift view
const DataDriftView = ({
  windowParameters,
  dataView,
  searchString,
  searchQueryLanguage,
  onReset,
  isBrushCleared,
  lastRefresh,
  onRefresh,
  initialSettings,
  hasValidTimeField
}) => {
  var _result$progressMessa;
  const [showDataComparisonOnly, setShowDataComparisonOnly] = (0, _react.useState)(false);
  const [currentAnalysisWindowParameters, setCurrentAnalysisWindowParameters] = (0, _react.useState)(windowParameters);
  const canAnalyzeDataDrift = (0, _react.useMemo)(() => {
    return !hasValidTimeField || (0, _mlIsPopulatedObject.isPopulatedObject)(windowParameters, ['baselineMin', 'baselineMax', 'deviationMin', 'deviationMax']);
  }, [windowParameters, hasValidTimeField]);
  const [fetchInfo, setFetchIno] = (0, _react.useState)();
  const refresh = (0, _react.useCallback)(() => {
    setCurrentAnalysisWindowParameters(windowParameters);
    const mergedFields = [];
    if (dataView) {
      mergedFields.push(...dataView.fields.filter(f => f.aggregatable === true &&
      // @ts-ignore metadata does exist
      f.spec.metadata_field !== true && (0, _use_data_drift_result.getDataComparisonType)(f.type) !== 'unsupported' && mergedFields.findIndex(merged => merged.field === f.name) === -1).map(f => ({
        field: f.name,
        type: (0, _use_data_drift_result.getDataComparisonType)(f.type),
        secondaryType: (0, _field_types_utils.kbnTypeToSupportedType)(f),
        displayName: f.displayName
      })));
    }
    setFetchIno({
      fields: mergedFields,
      currentDataView: dataView,
      ...(windowParameters ? {
        timeRanges: {
          reference: {
            start: windowParameters.baselineMin,
            end: windowParameters.baselineMax
          },
          comparison: {
            start: windowParameters.deviationMin,
            end: windowParameters.deviationMax
          }
        }
      } : {})
    });
    if (onRefresh) {
      onRefresh();
    }
  }, [dataView, windowParameters, onRefresh]);
  const {
    result,
    cancelRequest
  } = (0, _use_data_drift_result.useFetchDataComparisonResult)({
    ...fetchInfo,
    initialSettings,
    lastRefresh,
    searchString,
    searchQueryLanguage
  });
  const filteredData = (0, _react.useMemo)(() => {
    if (!(result !== null && result !== void 0 && result.data)) return [];
    switch (showDataComparisonOnly) {
      case true:
        return result.data.filter(d => d.driftDetected === true);
      default:
        return result.data;
    }
  }, [result.data, showDataComparisonOnly]);
  const {
    onTableChange,
    pagination,
    sorting,
    setPageIndex
  } = (0, _mlInMemoryTable.useTableState)(filteredData, 'driftDetected', 'desc');
  const shouldRerunAnalysis = (0, _react.useMemo)(() => currentAnalysisWindowParameters !== undefined && !(0, _lodash.isEqual)(currentAnalysisWindowParameters, windowParameters), [currentAnalysisWindowParameters, windowParameters]);
  const onShowDataComparisonOnlyToggle = e => {
    setShowDataComparisonOnly(e.target.checked);
    setPageIndex(0);
  };
  const requiresWindowParameters = (dataView === null || dataView === void 0 ? void 0 : dataView.isTimeBased()) && windowParameters === undefined;
  const showRunAnalysisHint = result.status === 'not_initiated';
  if (requiresWindowParameters) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      color: "subdued",
      hasShadow: false,
      hasBorder: false,
      css: {
        minWidth: '100%'
      },
      title: /*#__PURE__*/_react.default.createElement("h2", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.dataDrift.emptyPromptTitle",
        defaultMessage: "Click and select a time range for Reference and Comparison data in the histogram chart to compare data distribution.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 13
        }
      })),
      titleSize: "xs",
      body: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 191,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.dataDrift.emptyPromptBody",
        defaultMessage: "The Data Drift Viewer visualizes changes in the model input data, which can lead to model performance degradation over time. Detecting data drifts enables you to identify potential performance issues.",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 192,
          columnNumber: 13
        }
      })),
      "data-test-subj": "dataDriftNoWindowParametersEmptyPrompt",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 7
      }
    });
  }
  if (showRunAnalysisHint) {
    return /*#__PURE__*/_react.default.createElement(_data_drift_hint.DataDriftPromptHint, {
      refresh: refresh,
      canAnalyzeDataDrift: canAnalyzeDataDrift,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 203,
        columnNumber: 12
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_aiopsComponents.ProgressControls, {
    isBrushCleared: isBrushCleared,
    onReset: onReset,
    progress: result.loaded,
    progressMessage: (_result$progressMessa = result.progressMessage) !== null && _result$progressMessa !== void 0 ? _result$progressMessa : '',
    isRunning: result.loaded > 0 && result.loaded < 1,
    onRefresh: refresh,
    onCancel: cancelRequest,
    shouldRerunAnalysis: shouldRerunAnalysis,
    runAnalysisDisabled: !dataView || requiresWindowParameters,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: showOnlyDriftedFieldsOptionLabel,
    "aria-label": showOnlyDriftedFieldsOptionLabel,
    checked: showDataComparisonOnly,
    onChange: onShowDataComparisonOnlyToggle,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 220,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 230,
      columnNumber: 7
    }
  }), result.error ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    css: {
      minWidth: '100%'
    },
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 18
      }
    }, result.error),
    titleSize: "xs",
    body: /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 17
      }
    }, result.errorBody),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }) : /*#__PURE__*/_react.default.createElement(_data_drift_overview_table.DataDriftOverviewTable, {
    data: filteredData,
    onTableChange: onTableChange,
    pagination: pagination,
    sorting: sorting,
    setPageIndex: setPageIndex,
    status: result.status,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 9
    }
  }));
};
exports.DataDriftView = DataDriftView;