"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExamplesList = exports.EMPTY_EXAMPLE = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _expanded_row_field_header = require("../stats_table/components/expanded_row_field_header");
var _expanded_row_panel = require("../stats_table/components/field_data_expanded_row/expanded_row_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/examples_list/examples_list.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EMPTY_EXAMPLE = exports.EMPTY_EXAMPLE = _i18n.i18n.translate('xpack.dataVisualizer.dataGrid.field.examplesList.emptyExampleMessage', {
  defaultMessage: '(empty)'
});
const ExamplesList = ({
  examples
}) => {
  if (examples === undefined || examples === null || !Array.isArray(examples)) {
    return null;
  }
  let examplesContent;
  if (examples.length === 0) {
    examplesContent = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.dataVisualizer.dataGrid.field.examplesList.noExamplesMessage",
      defaultMessage: "No examples were obtained for this field",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 7
      }
    });
  } else {
    examplesContent = examples.map((example, i) => {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
        size: "xs",
        key: `example_${i}`,
        label: typeof example === 'string' ? example === '' ? EMPTY_EXAMPLE : example : JSON.stringify(example),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 42,
          columnNumber: 9
        }
      });
    });
  }
  return /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    dataTestSubj: "dataVisualizerFieldDataExamplesList",
    className: "dvText__wrapper dvPanel__wrapper",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_expanded_row_field_header.ExpandedRowFieldHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.dataGrid.field.examplesList.title",
    defaultMessage: "{numExamples, plural, one {Value} other {Examples}}",
    values: {
      numExamples: examples.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    showToolTips: true,
    maxWidth: 's',
    gutterSize: 'none',
    flush: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 7
    }
  }, examplesContent));
};
exports.ExamplesList = ExamplesList;