"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.spacesWarningText = exports.relationshipCalloutText = exports.DeleteModalContent = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/delete_data_view_flyout/delete_data_view_flyout_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const all = _i18n.i18n.translate('indexPatternManagement.dataViewTable.spaceCountAll', {
  defaultMessage: 'all'
});
const dataViewColumnName = _i18n.i18n.translate('indexPatternManagement.dataViewTable.dataViewColumnName', {
  defaultMessage: 'Data view'
});
const spacesColumnName = _i18n.i18n.translate('indexPatternManagement.dataViewTable.spacesColumnName', {
  defaultMessage: 'Spaces'
});
const tableTitle = _i18n.i18n.translate('indexPatternManagement.dataViewTable.tableTitle', {
  defaultMessage: 'Data views selected for deletion'
});
const spacesWarningText = exports.spacesWarningText = _i18n.i18n.translate('indexPatternManagement.dataViewTable.deleteWarning', {
  defaultMessage: 'Deleting a data view permanently removes it from all spaces and prevents all users from using it in any Kibana app such as Discover, Dashboards, or Lens. This action cannot be undone.'
});
const relationshipCalloutText = exports.relationshipCalloutText = _i18n.i18n.translate('indexPatternManagement.dataViewTable.deleteDanger', {
  defaultMessage: 'At least one of the data views you want to delete is used by another Kibana object. Review the list of affected objects to avoid any disruptions for other Kibana users relying on them. Deleting data views permanently removes them from all spaces and cannot be undone.'
});
const DeleteModalContent = ({
  views,
  hasSpaces,
  relationships,
  reviewedItems,
  setReviewedItems
}) => {
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const toggleDetails = id => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[id]) {
      delete itemIdToExpandedRowMapValues[id];
    } else {
      const relationsColumns = [{
        field: 'meta',
        name: _i18n.i18n.translate('indexPatternManagement.dataViewTable.relationshipMetaTitle', {
          defaultMessage: 'Name'
        }),
        render: meta => {
          return meta.inAppUrl ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            target: "_blank",
            href: meta.inAppUrl.path,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 97,
              columnNumber: 15
            }
          }, meta.title) : meta.title;
        }
      }, {
        field: 'type',
        name: _i18n.i18n.translate('indexPatternManagement.dataViewTable.relationshipType', {
          defaultMessage: 'Type'
        })
      }];
      const relationsTable = /*#__PURE__*/_react.default.createElement("div", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 113,
          columnNumber: 9
        }
      }, relationships[id].length === _constants.MAX_DISPLAYED_RELATIONSHIPS && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 15
        }
      }, _i18n.i18n.translate('indexPatternManagement.dataViewTable.maxRelationshipsShown', {
        defaultMessage: 'Only the first {maxRelationships} relationships are shown.',
        values: {
          maxRelationships: _constants.MAX_DISPLAYED_RELATIONSHIPS
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
        items: relationships[id],
        columns: relationsColumns,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 11
        }
      }));
      itemIdToExpandedRowMapValues[id] = relationsTable;
      setReviewedItems(new Set(reviewedItems).add(id));
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const columns = [{
    field: 'name',
    name: dataViewColumnName,
    sortable: true
  }, ...(hasSpaces ? [{
    field: 'namespaces',
    name: spacesColumnName,
    sortable: true,
    width: '100px',
    align: 'right',
    render: namespaces => namespaces.indexOf('*') !== -1 ? all : namespaces.length
  }] : []), {
    field: 'id',
    align: 'right',
    isExpander: true,
    name: /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 159,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 160,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('indexPatternManagement.dataViewTable.viewRelationships', {
      defaultMessage: 'View relationships'
    }))),
    render: id => {
      var _relationships$id;
      const itemIdToExpandedRowMapValues = {
        ...itemIdToExpandedRowMap
      };
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, (_relationships$id = relationships[id]) !== null && _relationships$id !== void 0 && _relationships$id.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        css: {
          width: 'auto'
        },
        onClick: () => toggleDetails(id),
        "aria-label": itemIdToExpandedRowMapValues[id] ? 'Collapse' : 'Expand',
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 173,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        justifyContent: "flexEnd",
        gutterSize: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 179,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 180,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('indexPatternManagement.dataViewTable.review', {
        defaultMessage: 'Review'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 185,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: itemIdToExpandedRowMapValues[id] ? 'arrowDown' : 'arrowRight',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 186,
          columnNumber: 19
        }
      }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null));
    }
  }];
  views = views.map((view, index) => ({
    ...view,
    name: view.getName(),
    relationships: relationships[index]
  }));
  const showRelationshipsCallout = Object.keys(relationships).some(key => relationships[key].length > 0);
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 5
    }
  }, showRelationshipsCallout ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    iconType: "warning",
    title: relationshipCalloutText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 11
    }
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "warning",
    title: spacesWarningText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "indexPatternManagement.dataViewTable.deleteConfirmSummary",
    defaultMessage: "Successfully deleted {count, number} {count, plural, one {data view} other {data views}\n}.",
    values: {
      count: views.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    tableCaption: tableTitle,
    items: views,
    itemId: "id",
    itemIdToExpandedRowMap: itemIdToExpandedRowMap,
    columns: columns,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 7
    }
  }));
};
exports.DeleteModalContent = DeleteModalContent;