"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ModalService = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _rxjs = require("rxjs");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _overlay_mount_wrapper = require("../overlay_mount_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/overlays/browser-internal/src/modal/modal_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/* eslint-disable max-classes-per-file */
/**
 * A ModalRef is a reference to an opened modal. It offers methods to
 * close the modal.
 *
 * @public
 */
class ModalRef {
  constructor() {
    (0, _defineProperty2.default)(this, "onClose", void 0);
    (0, _defineProperty2.default)(this, "closeSubject", new _rxjs.Subject());
    this.onClose = this.closeSubject.toPromise();
  }

  /**
   * Closes the referenced modal if it's still open which in turn will
   * resolve the `onClose` Promise. If the modal had already been
   * closed this method does nothing.
   */
  close() {
    if (!this.closeSubject.closed) {
      this.closeSubject.next();
      this.closeSubject.complete();
    }
    return this.onClose;
  }
}
/** @internal */
class ModalService {
  constructor() {
    (0, _defineProperty2.default)(this, "activeModal", null);
    (0, _defineProperty2.default)(this, "targetDomElement", null);
  }
  start({
    targetDomElement,
    ...startDeps
  }) {
    this.targetDomElement = targetDomElement;
    return {
      open: (mount, options = {}) => {
        // If there is an active modal, close it before opening a new one.
        if (this.activeModal) {
          this.activeModal.close();
          this.cleanupDom();
        }
        const modal = new ModalRef();

        // If a modal gets closed through it's ModalRef, remove it from the dom
        modal.onClose.then(() => {
          if (this.activeModal === modal) {
            this.cleanupDom();
          }
        });
        this.activeModal = modal;
        (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startDeps, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 11
          }
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiModal, (0, _extends2.default)({}, options, {
          onClose: () => modal.close(),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 96,
            columnNumber: 13
          }
        }), /*#__PURE__*/_react.default.createElement(_overlay_mount_wrapper.OverlayMountWrapper, {
          mount: mount,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 15
          }
        }))), targetDomElement);
        return modal;
      },
      openConfirm: (message, options) => {
        // If there is an active modal, close it before opening a new one.
        if (this.activeModal) {
          this.activeModal.close();
          this.cleanupDom();
        }
        const modalTitleId = (0, _eui.htmlIdGenerator)()();
        return new Promise((resolve, reject) => {
          let resolved = false;
          const closeModal = confirmed => {
            resolved = true;
            modal.close();
            resolve(confirmed);
          };
          const modal = new ModalRef();
          modal.onClose.then(() => {
            if (this.activeModal === modal) {
              this.cleanupDom();
            }
            // modal.close can be called when opening a new modal/confirm, so we need to resolve the promise in that case.
            if (!resolved) {
              closeModal(false);
            }
          });
          this.activeModal = modal;
          const props = {
            ...options,
            children: typeof message === 'string' ? message : /*#__PURE__*/_react.default.createElement(_overlay_mount_wrapper.OverlayMountWrapper, {
              mount: message,
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 137,
                columnNumber: 55
              }
            }),
            onCancel: () => closeModal(false),
            onConfirm: () => closeModal(true),
            cancelButtonText: (options === null || options === void 0 ? void 0 : options.cancelButtonText) || _i18n.i18n.translate('core.overlays.confirm.cancelButton', {
              defaultMessage: 'Cancel'
            }),
            confirmButtonText: (options === null || options === void 0 ? void 0 : options.confirmButtonText) || _i18n.i18n.translate('core.overlays.confirm.okButton', {
              defaultMessage: 'Confirm'
            })
          };
          (0, _reactDom.render)(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, startDeps, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 153,
              columnNumber: 13
            }
          }), /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, (0, _extends2.default)({
            "aria-labelledby": modalTitleId,
            titleProps: {
              id: modalTitleId
            }
          }, props, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 154,
              columnNumber: 15
            }
          }))), targetDomElement);
        });
      }
    };
  }

  /**
   * Using React.Render to re-render into a target DOM element will replace
   * the content of the target but won't call unmountComponent on any
   * components inside the target or any of their children. So we properly
   * cleanup the DOM here to prevent subtle bugs in child components which
   * depend on unmounting for cleanup behaviour.
   */
  cleanupDom() {
    if (this.targetDomElement != null) {
      (0, _reactDom.unmountComponentAtNode)(this.targetDomElement);
      this.targetDomElement.innerHTML = '';
    }
    this.activeModal = null;
  }
}
exports.ModalService = ModalService;