"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OptionsListPopoverEmptyMessage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _options_list_context_provider = require("../options_list_context_provider");
var _options_list_strings = require("../options_list_strings");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/controls/public/controls/data_controls/options_list_control/components/options_list_popover_empty_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OptionsListPopoverEmptyMessage = ({
  showOnlySelected
}) => {
  const {
    componentApi
  } = (0, _options_list_context_provider.useOptionsListContext)();
  const [searchTechnique, searchStringValid, field] = (0, _presentationPublishing.useBatchedPublishingSubjects)(componentApi.searchTechnique$, componentApi.searchStringValid$, componentApi.field$);
  const noResultsMessage = (0, _react.useMemo)(() => {
    if (showOnlySelected) {
      return _options_list_strings.OptionsListStrings.popover.getSelectionsEmptyMessage();
    }
    if (!searchStringValid && field && searchTechnique) {
      return _options_list_strings.OptionsListStrings.popover.getInvalidSearchMessage(field.type);
    }
    return _options_list_strings.OptionsListStrings.popover.getEmptyMessage();
  }, [showOnlySelected, field, searchStringValid, searchTechnique]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableMessage, {
    tabIndex: 0,
    "data-test-subj": `optionsList-control-${showOnlySelected ? 'selectionsEmptyMessage' : 'noSelectionsMessage'}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: searchStringValid ? 'minusInCircle' : 'alert',
    color: searchStringValid ? 'default' : 'danger',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }), noResultsMessage);
};
exports.OptionsListPopoverEmptyMessage = OptionsListPopoverEmptyMessage;