"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PalettePicker = PalettePicker;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _palettes = require("../../palettes");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-coloring/src/shared_components/coloring/palette_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function getCustomPaletteConfig(palettes, activePalette) {
  var _activePalette$params3;
  const {
    id,
    title
  } = palettes.get(_palettes.CUSTOM_PALETTE);

  // Try to generate a palette from the current one
  if (activePalette && activePalette.name !== _palettes.CUSTOM_PALETTE) {
    const currentPalette = palettes.get(activePalette.name);
    if (currentPalette) {
      var _activePalette$params, _activePalette$params2;
      const stops = currentPalette.getCategoricalColors((activePalette === null || activePalette === void 0 ? void 0 : (_activePalette$params = activePalette.params) === null || _activePalette$params === void 0 ? void 0 : _activePalette$params.steps) || _palettes.DEFAULT_COLOR_STEPS, activePalette === null || activePalette === void 0 ? void 0 : activePalette.params);
      const palette = (_activePalette$params2 = activePalette.params) !== null && _activePalette$params2 !== void 0 && _activePalette$params2.reverse ? stops.reverse() : stops;
      return {
        value: id,
        title,
        type: _palettes.FIXED_PROGRESSION,
        palette,
        'data-test-subj': `custom-palette`
      };
    }
  }
  // if not possible just show some text
  if (!(activePalette !== null && activePalette !== void 0 && (_activePalette$params3 = activePalette.params) !== null && _activePalette$params3 !== void 0 && _activePalette$params3.stops)) {
    return {
      value: id,
      title,
      type: 'text',
      'data-test-subj': `custom-palette`
    };
  }

  // full custom palette
  return {
    value: id,
    title,
    type: _palettes.FIXED_PROGRESSION,
    'data-test-subj': `custom-palette`,
    palette: (activePalette.params.colorStops || activePalette.params.stops).map(colorStop => colorStop.color)
  };
}

// Note: this is a special palette picker different from the one in the root shared folder
// ideally these should be merged together, but as for now this holds some custom logic hard to remove
function PalettePicker({
  palettes,
  activePalette,
  setPalette,
  showCustomPalette,
  showDynamicColorOnly,
  ...rest
}) {
  const palettesToShow = palettes.getAll().filter(({
    internal,
    canDynamicColoring
  }) => {
    return showDynamicColorOnly ? canDynamicColoring && !internal : !internal;
  }).map(({
    id,
    title,
    getCategoricalColors
  }) => {
    var _activePalette$params4;
    const colors = getCategoricalColors((activePalette === null || activePalette === void 0 ? void 0 : (_activePalette$params4 = activePalette.params) === null || _activePalette$params4 === void 0 ? void 0 : _activePalette$params4.steps) || _palettes.DEFAULT_COLOR_STEPS, id === (activePalette === null || activePalette === void 0 ? void 0 : activePalette.name) ? activePalette === null || activePalette === void 0 ? void 0 : activePalette.params : undefined);
    return {
      value: id,
      title,
      type: _palettes.FIXED_PROGRESSION,
      palette: colors,
      'data-test-subj': `${id}-palette`
    };
  });
  if (showCustomPalette) {
    palettesToShow.push(getCustomPaletteConfig(palettes, activePalette));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, (0, _extends2.default)({
    fullWidth: true,
    "data-test-subj": "lns-palettePicker",
    compressed: true,
    palettes: palettesToShow,
    onChange: newPalette => {
      setPalette({
        type: 'palette',
        name: newPalette
      });
    },
    valueOfSelected: (activePalette === null || activePalette === void 0 ? void 0 : activePalette.name) || _palettes.DEFAULT_PALETTE_NAME,
    selectionDisplay: "palette"
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }));
}