"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfigSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _mime_types = require("../common/constants/mime_types");
var _incremental_id = require("../common/constants/incremental_id");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigSchema = exports.ConfigSchema = _configSchema.schema.object({
  markdownPlugins: _configSchema.schema.object({
    lens: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  files: _configSchema.schema.object({
    allowedMimeTypes: _configSchema.schema.arrayOf(_configSchema.schema.string({
      minLength: 1
    }), {
      defaultValue: _mime_types.ALLOWED_MIME_TYPES
    }),
    // intentionally not setting a default here so that we can determine if the user set it
    maxSize: _configSchema.schema.maybe(_configSchema.schema.number({
      min: 0
    }))
  }),
  stack: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  }),
  incrementalId: _configSchema.schema.object({
    /**
     * Whether the incremental id service should be enabled
     */
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    }),
    /**
     * The interval that the task should be scheduled at
     */
    taskIntervalMinutes: _configSchema.schema.number({
      defaultValue: _incremental_id.DEFAULT_TASK_INTERVAL_MINUTES,
      min: 5
    }),
    /**
     * The initial delay the task will be started with
     */
    taskStartDelayMinutes: _configSchema.schema.number({
      defaultValue: _incremental_id.DEFAULT_TASK_START_DELAY_MINUTES,
      min: 1
    })
  }),
  analytics: _configSchema.schema.object({
    index: _configSchema.schema.object({
      enabled: (0, _configSchema.offeringBasedSchema)({
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        }),
        traditional: _configSchema.schema.boolean({
          defaultValue: false
        })
      })
    })
  }),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  resilient: _configSchema.schema.object({
    additionalFields: _configSchema.schema.object({
      enabled: (0, _configSchema.offeringBasedSchema)({
        serverless: _configSchema.schema.boolean({
          defaultValue: false
        }),
        traditional: _configSchema.schema.boolean({
          defaultValue: true
        })
      })
    })
  })
});