"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementMenu = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _sharedUxButtonToolbar = require("@kbn/shared-ux-button-toolbar");
var _i18n = require("@kbn/i18n");
var _get_id = require("../../../lib/get_id");
var _lib = require("../../../../common/lib");
var _flatten_panel_tree = require("../../../lib/flatten_panel_tree");
var _asset_manager = require("../../asset_manager");
var _saved_elements_modal = require("../../saved_elements_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/element_menu/element_menu.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getAssetsMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.manageAssetsMenuItemLabel', {
    defaultMessage: 'Manage assets'
  }),
  getChartMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.chartMenuItemLabel', {
    defaultMessage: 'Chart'
  }),
  getElementMenuButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.elementMenuButtonLabel', {
    defaultMessage: 'Add element'
  }),
  getElementMenuLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.elementMenuLabel', {
    defaultMessage: 'Add an element'
  }),
  getFilterMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.filterMenuItemLabel', {
    defaultMessage: 'Filter'
  }),
  getImageMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.imageMenuItemLabel', {
    defaultMessage: 'Image'
  }),
  getMyElementsMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.myElementsMenuItemLabel', {
    defaultMessage: 'My elements'
  }),
  getOtherMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.otherMenuItemLabel', {
    defaultMessage: 'Other'
  }),
  getProgressMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.progressMenuItemLabel', {
    defaultMessage: 'Progress'
  }),
  getShapeMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.shapeMenuItemLabel', {
    defaultMessage: 'Shape'
  }),
  getTextMenuItemLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderElementMenu.textMenuItemLabel', {
    defaultMessage: 'Text'
  })
};

// label and icon for the context menu item for each element type
const elementTypeMeta = {
  chart: {
    name: strings.getChartMenuItemLabel(),
    icon: 'visArea'
  },
  filter: {
    name: strings.getFilterMenuItemLabel(),
    icon: 'filter'
  },
  image: {
    name: strings.getImageMenuItemLabel(),
    icon: 'image'
  },
  other: {
    name: strings.getOtherMenuItemLabel(),
    icon: 'empty'
  },
  progress: {
    name: strings.getProgressMenuItemLabel(),
    icon: 'visGoal'
  },
  shape: {
    name: strings.getShapeMenuItemLabel(),
    icon: 'node'
  },
  text: {
    name: strings.getTextMenuItemLabel(),
    icon: 'visText'
  }
};
const getElementType = element => element && element.type && Object.keys(elementTypeMeta).includes(element.type) ? element.type : 'other';
const categorizeElementsByType = elements => {
  elements = (0, _lodash.sortBy)(elements, 'displayName');
  const categories = {
    other: []
  };
  elements.forEach(element => {
    const type = getElementType(element);
    if (categories[type]) {
      categories[type].push(element);
    } else {
      categories[type] = [element];
    }
  });
  return categories;
};
const ElementMenu = ({
  elements,
  addElement
}) => {
  const [isAssetModalVisible, setAssetModalVisible] = (0, _react.useState)(false);
  const [isSavedElementsModalVisible, setSavedElementsModalVisible] = (0, _react.useState)(false);
  const hideAssetModal = () => setAssetModalVisible(false);
  const showAssetModal = () => setAssetModalVisible(true);
  const hideSavedElementsModal = () => setSavedElementsModalVisible(false);
  const showSavedElementsModal = () => setSavedElementsModalVisible(true);
  const {
    chart: chartElements,
    filter: filterElements,
    image: imageElements,
    other: otherElements,
    progress: progressElements,
    shape: shapeElements,
    text: textElements
  } = categorizeElementsByType(Object.values(elements));
  const getPanelTree = closePopover => {
    const elementToMenuItem = element => ({
      name: element.displayName || element.name,
      icon: element.icon,
      onClick: () => {
        addElement(element);
        closePopover();
      },
      'data-test-subj': `canvasAddElementMenu__${element.name}`
    });
    const elementListToMenuItems = elementList => {
      const type = getElementType(elementList[0]);
      const {
        name,
        icon
      } = elementTypeMeta[type] || elementTypeMeta.other;
      if (elementList.length > 1) {
        return {
          name,
          icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: icon,
            size: "m",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 161,
              columnNumber: 17
            }
          }),
          panel: {
            id: (0, _get_id.getId)('element-type'),
            title: name,
            items: elementList.map(elementToMenuItem)
          },
          'data-test-subj': `canvasAddElementMenu__${name}`
        };
      }
      return elementToMenuItem(elementList[0]);
    };
    return {
      id: 0,
      items: [elementListToMenuItems(textElements), elementListToMenuItems(shapeElements), elementListToMenuItems(chartElements), elementListToMenuItems(imageElements), elementListToMenuItems(filterElements), elementListToMenuItems(progressElements), elementListToMenuItems(otherElements), {
        name: strings.getMyElementsMenuItemLabel(),
        className: _lib.CONTEXT_MENU_TOP_BORDER_CLASSNAME,
        'data-test-subj': 'saved-elements-menu-option',
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "empty",
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 188,
            columnNumber: 17
          }
        }),
        onClick: () => {
          showSavedElementsModal();
          closePopover();
        }
      }, {
        name: strings.getAssetsMenuItemLabel(),
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          type: "empty",
          size: "m",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 196,
            columnNumber: 17
          }
        }),
        onClick: () => {
          showAssetModal();
          closePopover();
        }
      }]
    };
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxButtonToolbar.ToolbarPopover, {
    type: "primary",
    panelPaddingSize: "none",
    label: strings.getElementMenuButtonLabel(),
    iconType: "plusInCircle",
    "data-test-subj": "add-element-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }, ({
    closePopover
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: (0, _flatten_panel_tree.flattenPanelTree)(getPanelTree(closePopover)),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 11
    }
  })), isAssetModalVisible ? /*#__PURE__*/_react.default.createElement(_asset_manager.AssetManager, {
    onClose: hideAssetModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 30
    }
  }) : null, isSavedElementsModalVisible ? /*#__PURE__*/_react.default.createElement(_saved_elements_modal.SavedElementsModal, {
    onClose: hideSavedElementsModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 38
    }
  }) : null);
};
exports.ElementMenu = ElementMenu;
ElementMenu.propTypes = {
  elements: _propTypes.default.object,
  addElement: _propTypes.default.func.isRequired
};