"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.teardownCanvas = exports.renderApp = exports.initializeCanvas = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _reactRedux = require("react-redux");
require("@kbn/flot-charts");
var _lodash = require("lodash");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public = require("@kbn/kibana-react-plugin/public");
var _app = require("./components/app");
var _registries = require("./registries");
var _help_menu = require("./components/help_menu/help_menu");
var _store = require("./store");
var _ui_metric = require("./lib/ui_metric");
var _i18n2 = require("../i18n");
var _services = require("./services");
var _functions = require("./functions");
var _app2 = require("./state/actions/app");
var _size = require("../canvas_plugin_src/renderers/plot/plugins/size");
var _text = require("../canvas_plugin_src/renderers/plot/plugins/text");
require("./style/index.scss");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/application.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error untyped local
// @ts-expect-error Not going to convert
// @ts-expect-error Not going to convert
const {
  ReadOnlyBadge: strings
} = _i18n2.CapabilitiesStrings;
const renderApp = ({
  coreStart,
  startPlugins,
  params,
  canvasStore,
  appUpdater
}) => {
  const {
    element
  } = params;
  element.classList.add('canvas');
  element.classList.add('canvasContainerWrapper');
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: {
      ...startPlugins,
      ...coreStart
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_services.LegacyServicesProvider, {
    providers: _services.services,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: canvasStore,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_app.App, {
    history: params.history,
    appUpdater: appUpdater,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }))))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
    canvasStore.dispatch((0, _app2.appUnload)());
  };
};
exports.renderApp = renderApp;
const initializeCanvas = async (coreSetup, coreStart, setupPlugins, startPlugins, registries, appUpdater) => {
  await (0, _services.startLegacyServices)(coreSetup, coreStart, setupPlugins, startPlugins, appUpdater);
  const {
    expressions
  } = setupPlugins;

  // Adding these functions here instead of in plugin.ts.
  // Some of these functions have deep dependencies into Canvas, which was bulking up the size
  // of our bundle entry point. Moving them here pushes that load to when canvas is actually loaded.
  const canvasFunctions = (0, _functions.initFunctions)({
    http: coreSetup.http,
    timefilter: setupPlugins.data.query.timefilter.timefilter,
    types: setupPlugins.expressions.getTypes(),
    paletteService: await setupPlugins.charts.palettes.getPalettes()
  });
  for (const fn of canvasFunctions) {
    expressions.registerFunction(fn);
  }

  // Create Store
  const canvasStore = await (0, _store.createStore)(coreSetup);

  // Init Registries
  (0, _registries.initRegistries)();
  await (0, _registries.populateRegistries)(registries);

  // Set Badge
  coreStart.chrome.setBadge(coreStart.application.capabilities.canvas && coreStart.application.capabilities.canvas.save ? undefined : {
    text: strings.getText(),
    tooltip: strings.getTooltip(),
    iconType: 'glasses'
  });

  // Setup documentation links
  const {
    docLinks
  } = coreStart;
  // Set help extensions
  coreStart.chrome.setHelpExtension({
    appName: _i18n.i18n.translate('xpack.canvas.helpMenu.appName', {
      defaultMessage: 'Canvas'
    }),
    links: [{
      linkType: 'documentation',
      href: docLinks.links.canvas.guide
    }],
    content: (domNode, {
      hideHelpMenu
    }) => {
      _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 9
        }
      }), /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
        store: canvasStore,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
        hideHelpMenu: hideHelpMenu,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 13
        }
      }))), domNode);
      return () => _reactDom.default.unmountComponentAtNode(domNode);
    }
  });
  if (setupPlugins.usageCollection) {
    (0, _ui_metric.init)(setupPlugins.usageCollection.reportUiCounter);
  }
  return canvasStore;
};
exports.initializeCanvas = initializeCanvas;
const teardownCanvas = coreStart => {
  (0, _registries.destroyRegistries)();

  // Canvas pollutes the jQuery plot plugins collection with custom plugins that only work in Canvas.
  // Remove them when Canvas is unmounted.
  // see: ../canvas_plugin_src/renderers/plot/plugins/index.ts
  if ((0, _lodash.includes)($.plot.plugins, _size.size)) {
    (0, _lodash.remove)($.plot.plugins, _size.size);
  }
  if ((0, _lodash.includes)($.plot.plugins, _text.text)) {
    (0, _lodash.remove)($.plot.plugins, _text.text);
  }

  // TODO: Not cleaning these up temporarily.
  // We have an issue where if requests are inflight, and you navigate away,
  // those requests could still be trying to act on the store and possibly require services.
  // stopServices();
  // resetInterpreter();
  // destroyStore();

  coreStart.chrome.setBadge(undefined);
  coreStart.chrome.setHelpExtension(undefined);
};
exports.teardownCanvas = teardownCanvas;