"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionJobsContext = void 0;
exports.AnomalyDetectionJobsContextProvider = AnomalyDetectionJobsContextProvider;
var _react = _interopRequireWildcard(require("react"));
var _get_anomaly_detection_setup_state = require("../../../common/anomaly_detection/get_anomaly_detection_setup_state");
var _environment_filter_values = require("../../../common/environment_filter_values");
var _use_apm_params = require("../../hooks/use_apm_params");
var _use_fetcher = require("../../hooks/use_fetcher");
var _use_apm_plugin_context = require("../apm_plugin/use_apm_plugin_context");
var _use_license_context = require("../license/use_license_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/context/anomaly_detection_jobs/anomaly_detection_jobs_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyDetectionJobsContext = exports.AnomalyDetectionJobsContext = /*#__PURE__*/(0, _react.createContext)({});
function AnomalyDetectionJobsContextProvider({
  children
}) {
  var _core$application$cap, _data$jobs;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const canGetJobs = !!((_core$application$cap = core.application.capabilities.ml) !== null && _core$application$cap !== void 0 && _core$application$cap.canGetJobs);
  const license = (0, _use_license_context.useLicenseContext)();
  const hasValidLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('platinum'));
  const isAuthorized = !!(canGetJobs && hasValidLicense);
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!isAuthorized) {
      return;
    }
    return callApmApi(`GET /internal/apm/settings/anomaly-detection/jobs`);
  }, [isAuthorized], {
    showToastOnError: false
  });
  const {
    query
  } = (0, _use_apm_params.useApmParams)('/*');
  const environment = 'environment' in query && query.environment || _environment_filter_values.ENVIRONMENT_ALL.value;
  const anomalyDetectionSetupState = (0, _get_anomaly_detection_setup_state.getAnomalyDetectionSetupState)({
    environment,
    fetchStatus: status,
    jobs: (_data$jobs = data === null || data === void 0 ? void 0 : data.jobs) !== null && _data$jobs !== void 0 ? _data$jobs : [],
    isAuthorized
  });
  return /*#__PURE__*/_react.default.createElement(AnomalyDetectionJobsContext.Provider, {
    value: {
      anomalyDetectionJobsData: data,
      anomalyDetectionJobsStatus: status,
      anomalyDetectionJobsRefetch: refetch,
      anomalyDetectionSetupState
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }, children);
}