"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionTypeSelect = TransactionTypeSelect;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _use_apm_service_context = require("../../context/apm_service/use_apm_service_context");
var _use_breakpoints = require("../../hooks/use_breakpoints");
var urlHelpers = _interopRequireWildcard(require("./links/url_helpers"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/transaction_type_select.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
// The default transaction type (for non-RUM services) is "request". Set the
// min-width on here to the width when "request" is loaded so it doesn't start
// out collapsed and change its width when the list of transaction types is loaded.
const EuiSelectWithWidth = (0, _styled.default)(_eui.EuiSelect)`
  min-width: 200px;
`;
function TransactionTypeSelect() {
  const {
    isSmall
  } = (0, _use_breakpoints.useBreakpoints)();
  const {
    transactionTypes,
    transactionType
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const history = (0, _reactRouterDom.useHistory)();
  const handleChange = (0, _react.useCallback)(event => {
    const selectedTransactionType = event.currentTarget.value;
    urlHelpers.push(history, {
      query: {
        transactionType: selectedTransactionType
      }
    });
  }, [history]);
  const options = transactionTypes.map(t => ({
    text: t,
    value: t
  }));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(EuiSelectWithWidth, {
    fullWidth: isSmall,
    "aria-label": _i18n.i18n.translate('xpack.apm.serviceOverview.filterByTransactionTypeSelect.ariaLabel', {
      defaultMessage: 'Filter by transaction type select'
    }),
    "data-test-subj": "headerFilterTransactionType",
    onChange: handleChange,
    options: options,
    compressed: true,
    value: transactionType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 7
    }
  }));
}