"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionOverviewLink = TransactionOverviewLink;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _use_apm_router = require("../../../../hooks/use_apm_router");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/links/apm/transaction_overview_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TransactionOverviewLink({
  serviceName,
  latencyAggregationType,
  transactionType,
  query,
  ...rest
}) {
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const href = link('/services/{serviceName}/transactions', {
    path: {
      serviceName
    },
    query: {
      ...query,
      latencyAggregationType,
      transactionType: transactionType !== null && transactionType !== void 0 ? transactionType : query.transactionType
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "apmTransactionOverviewLinkLink",
    href: href
  }, rest, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 10
    }
  }));
}