"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzeDataButton = AnalyzeDataButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/exploratory-view-plugin/public");
var _agent_name = require("../../../../../common/agent_name");
var _apm = require("../../../../../common/es_fields/apm");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/routing/templates/apm_service_template/analyze_data_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getEnvironmentDefinition(environment) {
  switch (environment) {
    case _environment_filter_values.ENVIRONMENT_ALL.value:
      return {
        [_apm.SERVICE_ENVIRONMENT]: [_public2.ALL_VALUES_SELECTED]
      };
    case _environment_filter_values.ENVIRONMENT_NOT_DEFINED.value:
    default:
      return {
        [_apm.SERVICE_ENVIRONMENT]: [environment]
      };
  }
}
function AnalyzeDataButton() {
  var _services$http, _services$application;
  const {
    agentName,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    services
  } = (0, _public.useKibana)();
  const {
    query: {
      rangeFrom,
      rangeTo,
      environment
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}', '/mobile-services/{serviceName}');
  const basepath = (_services$http = services.http) === null || _services$http === void 0 ? void 0 : _services$http.basePath.get();
  const canShowDashboard = (_services$application = services.application) === null || _services$application === void 0 ? void 0 : _services$application.capabilities.dashboard_v2.show;
  if (((0, _agent_name.isRumAgentName)(agentName) || (0, _agent_name.isMobileAgentName)(agentName)) && rangeFrom && canShowDashboard && rangeTo) {
    const href = (0, _public2.createExploratoryViewUrl)({
      reportType: 'kpi-over-time',
      allSeries: [{
        name: `${serviceName}-response-latency`,
        selectedMetricField: _apm.TRANSACTION_DURATION,
        dataType: (0, _agent_name.isRumAgentName)(agentName) ? 'ux' : 'mobile',
        time: {
          from: rangeFrom,
          to: rangeTo
        },
        reportDefinitions: {
          [_apm.SERVICE_NAME]: [serviceName],
          ...(environment ? getEnvironmentDefinition(environment) : {})
        },
        operationType: 'average'
      }]
    }, basepath);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18n.i18n.translate('xpack.apm.analyzeDataButton.tooltip', {
        defaultMessage: 'Go to Explore Data, where you can select and filter result data in any dimension and look for the cause or impact of performance problems.'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "apmAnalyzeDataButtonExploreDataButton",
      href: href,
      iconType: "visBarVerticalStacked",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 9
      }
    }, _i18n.i18n.translate('xpack.apm.analyzeDataButton.label', {
      defaultMessage: 'Explore data'
    })));
  }
  return null;
}