"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomLinkOverview = CustomLinkOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _custom_link = require("../../../../../common/custom_link");
var _use_license_context = require("../../../../context/license/use_license_context");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _license_prompt = require("../../../shared/license_prompt");
var _create_custom_link_button = require("./create_custom_link_button");
var _create_edit_custom_link_flyout = require("./create_edit_custom_link_flyout");
var _custom_link_table = require("./custom_link_table");
var _empty_prompt = require("./empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/custom_link/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function CustomLinkOverview() {
  var _data$customLinks;
  const license = (0, _use_license_context.useLicenseContext)();
  const hasValidLicense = (license === null || license === void 0 ? void 0 : license.isActive) && (license === null || license === void 0 ? void 0 : license.hasAtLeast('gold'));
  const [isFlyoutOpen, setIsFlyoutOpen] = (0, _react.useState)(false);
  const [customLinkSelected, setCustomLinkSelected] = (0, _react.useState)();
  const {
    data,
    status,
    refetch
  } = (0, _use_fetcher.useFetcher)(async callApmApi => {
    if (hasValidLicense) {
      return callApmApi('GET /internal/apm/settings/custom_links');
    }
  }, [hasValidLicense]);
  const customLinks = (_data$customLinks = data === null || data === void 0 ? void 0 : data.customLinks) !== null && _data$customLinks !== void 0 ? _data$customLinks : [];
  (0, _react.useEffect)(() => {
    if (customLinkSelected) {
      setIsFlyoutOpen(true);
    }
  }, [customLinkSelected]);
  const onCloseFlyout = () => {
    setCustomLinkSelected(undefined);
    setIsFlyoutOpen(false);
  };
  const onCreateCustomLinkClick = () => {
    setIsFlyoutOpen(true);
  };
  const showEmptyPrompt = status === _use_fetcher.FETCH_STATUS.SUCCESS && (0, _lodash.isEmpty)(customLinks);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_edit_custom_link_flyout.CreateEditCustomLinkFlyout, {
    onClose: onCloseFlyout,
    defaults: customLinkSelected,
    customLinkId: customLinkSelected === null || customLinkSelected === void 0 ? void 0 : customLinkSelected.id,
    onSave: () => {
      onCloseFlyout();
      refetch();
    },
    onDelete: () => {
      onCloseFlyout();
      refetch();
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink', {
    defaultMessage: 'Custom Links'
  })))), hasValidLicense && !showEmptyPrompt && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_create_custom_link_button.CreateCustomLinkButton, {
    onClick: onCreateCustomLinkClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 17
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.settings.customLink.info', {
    defaultMessage: 'These links will be shown in the Actions context menu in selected areas of the app, e.g. by the transactions detail.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }), hasValidLicense ? showEmptyPrompt ? /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
    onCreateCustomLinkClick: onCreateCustomLinkClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_custom_link_table.CustomLinkTable, {
    items: customLinks,
    onCustomLinkSelected: setCustomLinkSelected,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_license_prompt.LicensePrompt, {
    text: _custom_link.INVALID_LICENSE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }));
}