"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedConfigKeyInput = AdvancedConfigKeyInput;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_configurations/agent_configuration_create_edit/settings_page/advanced_config_key_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AdvancedConfigKeyInput({
  configKey,
  id,
  showLabel,
  revalidate,
  onChange,
  checkIfAdvancedConfigKeyExists,
  checkIfPredefinedConfigKeyExists,
  addValidationError,
  removeValidationError
}) {
  // Handle key inputs with local state to avoid duplicated keys overwriting each other
  const [localKey, setLocalKey] = (0, _react.useState)(configKey);
  const [errorMsg, setErrorMsg] = (0, _react.useState)(null);
  const [isFormInvalid, setIsFormInvalid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    setLocalKey(configKey);
  }, [configKey]);
  const [touched, setTouched] = (0, _react.useState)(false);
  const getErrorMsg = (0, _react.useCallback)(key => {
    if (key === '') {
      return _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.keyEmptyError', {
        defaultMessage: 'Key cannot be empty'
      });
    }
    if (key.trim() === '') {
      return _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.keyEmptyError', {
        defaultMessage: 'Key cannot be only whitespace characters'
      });
    }
    if (checkIfPredefinedConfigKeyExists(key)) {
      return _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.keyPredefinedError', {
        defaultMessage: 'This key is already predefined in the standard configuration above'
      });
    }
    if (key !== configKey && checkIfAdvancedConfigKeyExists(key)) {
      return _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.keyDuplicateError', {
        defaultMessage: 'This key is already used in another advanced configuration'
      });
    }
    return null;
  }, [checkIfAdvancedConfigKeyExists, checkIfPredefinedConfigKeyExists, configKey]);
  (0, _react.useEffect)(() => {
    const errorId = `key${id}`;
    const newErrorMsg = getErrorMsg(localKey);
    const hasValidationErrors = newErrorMsg !== null;
    setErrorMsg(newErrorMsg);
    setIsFormInvalid((touched || revalidate) && hasValidationErrors);
    if (hasValidationErrors) {
      addValidationError(errorId, touched);
    } else {
      removeValidationError(errorId);
    }
  }, [id, addValidationError, removeValidationError, touched, localKey, revalidate, getErrorMsg]);
  const handleKeyChange = key => {
    const newErrorMsg = getErrorMsg(key);
    const noValidationErrors = newErrorMsg === null;
    setLocalKey(key);
    setTouched(true);
    if (noValidationErrors) {
      onChange({
        key,
        oldKey: configKey
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: showLabel ? _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.keyLabel', {
      defaultMessage: 'key'
    }) : undefined,
    error: errorMsg,
    isInvalid: isFormInvalid,
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "apmSettingsAdvancedConfigurationKeyField",
    "aria-label": _i18n.i18n.translate('xpack.apm.agentConfig.settingsPage.keyAriaLabel', {
      defaultMessage: 'Advanced configuration key'
    }),
    fullWidth: true,
    value: localKey,
    isInvalid: isFormInvalid,
    onChange: e => handleKeyChange(e.target.value),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }));
}