"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceDependenciesBreakdownChart = ServiceDependenciesBreakdownChart;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _viz_colors = require("../../../../common/viz_colors");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_time_range = require("../../../hooks/use_time_range");
var _breakdown_chart = require("../../shared/charts/breakdown_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/service_dependencies/service_dependencies_breakdown_chart.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ServiceDependenciesBreakdownChart({
  height
}) {
  var _data$breakdown$map;
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    query: {
      kuery,
      environment,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/dependencies', '/mobile-services/{serviceName}/dependencies');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    data,
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    return callApmApi('GET /internal/apm/services/{serviceName}/dependencies/breakdown', {
      params: {
        path: {
          serviceName
        },
        query: {
          start,
          end,
          kuery,
          environment
        }
      }
    });
  }, [serviceName, start, end, kuery, environment]);
  const timeseries = (_data$breakdown$map = data === null || data === void 0 ? void 0 : data.breakdown.map((item, index) => {
    return {
      title: item.title,
      data: item.data,
      type: 'area',
      color: (0, _viz_colors.getVizColorForIndex)(index, euiTheme)
    };
  })) !== null && _data$breakdown$map !== void 0 ? _data$breakdown$map : [];
  return /*#__PURE__*/_react.default.createElement(_breakdown_chart.BreakdownChart, {
    fetchStatus: status,
    height: height,
    showAnnotations: false,
    annotations: [],
    timeseries: timeseries,
    yAxisType: "duration",
    id: "serviceDependenciesBreakdownChart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  });
}