"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MobileErrorTabIds = void 0;
exports.Tabs = Tabs;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _errors_overview = require("../errors_overview");
var _crashes_overview = require("../crashes_overview");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/mobile/errors_and_crashes_overview/tabs/tabs.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MobileErrorTabIds = exports.MobileErrorTabIds = /*#__PURE__*/function (MobileErrorTabIds) {
  MobileErrorTabIds["ERRORS"] = "errors";
  MobileErrorTabIds["CRASHES"] = "crashes";
  return MobileErrorTabIds;
}({});
const tabs = [{
  id: MobileErrorTabIds.ERRORS,
  name: _i18n.i18n.translate('xpack.apm.mobile.errorsAndCrashes.errorsTab', {
    defaultMessage: 'Errors'
  }),
  'data-test-subj': 'apmMobileErrorsTabButton'
}, {
  id: MobileErrorTabIds.CRASHES,
  name: _i18n.i18n.translate('xpack.apm.mobile.errorsAndCrashes.crashesTab', {
    defaultMessage: 'Crashes'
  }),
  append: /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 13
    }
  }),
  'data-test-subj': 'apmMobileCrashesTabButton'
}];
function Tabs({
  mobileErrorTabId,
  onTabClick
}) {
  const selectedTabId = mobileErrorTabId;
  const tabEntries = tabs.map((tab, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, (0, _extends2.default)({}, tab, {
    key: tab.id,
    onClick: () => {
      onTabClick(tab.id);
    },
    isSelected: tab.id === selectedTabId,
    append: tab.append,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }), tab.name));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, tabEntries), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), selectedTabId === MobileErrorTabIds.ERRORS && /*#__PURE__*/_react.default.createElement(_errors_overview.MobileErrorsOverview, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 54
    }
  }), selectedTabId === MobileErrorTabIds.CRASHES && /*#__PURE__*/_react.default.createElement(_crashes_overview.MobileCrashesOverview, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 55
    }
  }));
}