"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorGroupOverview = ErrorGroupOverview;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _chart_pointer_event_context = require("../../../context/chart_pointer_event/chart_pointer_event_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_error_group_distribution_fetcher = require("../../../hooks/use_error_group_distribution_fetcher");
var _failed_transaction_rate_chart = require("../../shared/charts/failed_transaction_rate_chart");
var _distribution = require("../error_group_details/distribution");
var _error_group_list = require("./error_group_list");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763640253137490323/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/error_group_overview/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function ErrorGroupOverview() {
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    query: {
      environment,
      kuery,
      comparisonEnabled
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/errors');
  const {
    errorDistributionData,
    errorDistributionStatus
  } = (0, _use_error_group_distribution_fetcher.useErrorGroupDistributionFetcher)({
    serviceName,
    groupId: undefined,
    environment,
    kuery
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_chart_pointer_event_context.ChartPointerEventContextProvider, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_distribution.ErrorDistribution, {
    fetchStatus: errorDistributionStatus,
    distribution: errorDistributionData,
    title: _i18n.i18n.translate('xpack.apm.serviceDetails.metrics.errorOccurrencesChart.title', {
      defaultMessage: 'Error occurrences'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_failed_transaction_rate_chart.FailedTransactionRateChart, {
    kuery: kuery,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.apm.serviceDetails.metrics.errorsList.title', {
    defaultMessage: 'Errors'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_error_group_list.ErrorGroupList, {
    serviceName: serviceName,
    comparisonEnabled: comparisonEnabled,
    initialPageSize: 10,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 11
    }
  }))));
}